<?php
/**
 * frames.nameをframes_languagesテーブルへ移動
 *
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 * @copyright Copyright 2014, NetCommons Project
 */

App::uses('NetCommonsMigration', 'NetCommons.Config/Migration');

/**
 * frames.nameをframes_languagesテーブルへ移動
 *
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @package NetCommons\Frames\Config\Migration
 */
class MigrationFramesLanguages extends NetCommonsMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'migration_frames_languages';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(),
		'down' => array(),
	);

/**
 * Records keyed by model name.
 *
 * @var array $records
 */
	public $records = array();

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$Frame = $this->generateModel('Frame');
		$FramesLanguage = $this->generateModel('FramesLanguage');

		if ($direction === 'up') {
			$sql = 'INSERT INTO ' . $FramesLanguage->tablePrefix . $FramesLanguage->table .
					' SELECT ' .
						'Frame.id, Frame.language_id, Frame.id, Frame.name, 1, 0, ' .
						'Frame.created_user, Frame.created, Frame.modified_user, Frame.modified' .
					' FROM ' . $Frame->tablePrefix . $Frame->table . ' ' . $Frame->alias .
					' WHERE Frame.language_id = 2';
			$FramesLanguage->query($sql);

			$conditions = array(
				'Frame.language_id !=' => '2'
			);
			if (! $Frame->deleteAll($conditions, false)) {
				return false;
			}
		}
		return true;
	}
}
