<?php
/**
 * Add holiday migration
 *
 * @author Noriko Arai <arai@nii.ac.jp>
 * @author Allcreator <info@allcreator.net>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 * @copyright Copyright 2014, NetCommons Project
 */

App::uses('NetCommonsMigration', 'NetCommons.Config/Migration');

/**
 * Add plugin migration
 *
 * @package NetCommons\Holidays\Config\Migration
 * @SuppressWarnings(PHPMD.ExcessiveClassLength)
 */
class HolidayRecords extends NetCommonsMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'holiday_records';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(),
		'down' => array(),
	);

/**
 * plugin data
 *
 * @var array $migration
 */
	public $records = array(
		'HolidayRrule' => array(
			array('id' => 1, 'is_variable' => false, 'month_day' => '1970-01-01', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-01-01', 'end_year' => '1974-01-01', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=1;UNTIL=19731231T150000', ),
			array('id' => 2, 'is_variable' => false, 'month_day' => '1975-01-01', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1975-01-01', 'end_year' => '2033-01-01', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=1;UNTIL=20321231T150000', ),
			array('id' => 3, 'is_variable' => false, 'month_day' => '1970-01-15', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-01-15', 'end_year' => '1974-01-15', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=1;UNTIL=19740114T150000', ),
			array('id' => 4, 'is_variable' => false, 'month_day' => '1975-01-15', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1975-01-15', 'end_year' => '1999-01-15', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=1;UNTIL=19990114T150000', ),
			array('id' => 5, 'is_variable' => true, 'month_day' => '2000-1-10', 'week' => '2', 'day_of_the_week' => 'MO', 'can_substitute' => false, 'start_year' => '2000-01-10', 'end_year' => '2033-01-10', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=1;BYDAY=2MO;UNTIL=20330109T150000', ),
			array('id' => 6, 'is_variable' => false, 'month_day' => '1970-02-11', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-02-11', 'end_year' => '1974-02-11', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=2;UNTIL=19740210T150000', ),
			array('id' => 7, 'is_variable' => false, 'month_day' => '1975-02-11', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1975-02-11', 'end_year' => '2033-02-11', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=2;UNTIL=20330210T150000', ),
			array('id' => 8, 'is_variable' => false, 'month_day' => '1970-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-03-21', 'end_year' => '1970-03-21', 'rrule' => '', ),
			array('id' => 9, 'is_variable' => false, 'month_day' => '1971-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1971-03-21', 'end_year' => '1971-03-21', 'rrule' => '', ),
			array('id' => 10, 'is_variable' => false, 'month_day' => '1972-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1972-03-20', 'end_year' => '1972-03-20', 'rrule' => '', ),
			array('id' => 11, 'is_variable' => false, 'month_day' => '1973-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1973-03-21', 'end_year' => '1973-03-21', 'rrule' => '', ),
			array('id' => 12, 'is_variable' => false, 'month_day' => '1974-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1974-03-21', 'end_year' => '1974-03-21', 'rrule' => '', ),
			array('id' => 13, 'is_variable' => false, 'month_day' => '1970-04-29', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-04-29', 'end_year' => '1973-04-29', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=4;UNTIL=19730428T150000', ),
			array('id' => 14, 'is_variable' => false, 'month_day' => '1974-04-29', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-04-29', 'end_year' => '1988-04-29', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=4;UNTIL=19880428T150000', ),
			array('id' => 15, 'is_variable' => false, 'month_day' => '1989-04-29', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1989-04-29', 'end_year' => '2006-04-29', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=4;UNTIL=20060428T150000', ),
			array('id' => 16, 'is_variable' => false, 'month_day' => '2007-04-29', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2007-04-29', 'end_year' => '2033-04-29', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=4;UNTIL=20330428T150000', ),
			array('id' => 17, 'is_variable' => false, 'month_day' => '1970-05-03', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-05-03', 'end_year' => '1973-05-03', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=5;UNTIL=19730502T150000', ),
			array('id' => 18, 'is_variable' => false, 'month_day' => '1974-05-03', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-05-03', 'end_year' => '2033-05-03', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=5;UNTIL=20330502T150000', ),
			array('id' => 19, 'is_variable' => false, 'month_day' => '2007-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2007-05-04', 'end_year' => '2033-05-04', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=5;UNTIL=20330503T150000', ),
			array('id' => 20, 'is_variable' => false, 'month_day' => '1970-05-05', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-05-05', 'end_year' => '1973-05-05', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=5;UNTIL=19730504T150000', ),
			array('id' => 21, 'is_variable' => false, 'month_day' => '1974-05-05', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-05-05', 'end_year' => '2033-05-05', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=5;UNTIL=20330504T150000', ),
			array('id' => 22, 'is_variable' => false, 'month_day' => '1970-09-15', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-09-15', 'end_year' => '1973-09-15', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=9;UNTIL=19730914T150000', ),
			array('id' => 23, 'is_variable' => false, 'month_day' => '1974-09-15', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-09-15', 'end_year' => '2002-09-15', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=9;UNTIL=20020914T150000', ),
			array('id' => 24, 'is_variable' => true, 'month_day' => '2003-9-15', 'week' => '3', 'day_of_the_week' => 'MO', 'can_substitute' => false, 'start_year' => '2003-09-15', 'end_year' => '2033-09-19', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=9;BYDAY=3MO;UNTIL=20330918T150000', ),
			array('id' => 25, 'is_variable' => false, 'month_day' => '1970-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-09-23', 'end_year' => '1970-09-23', 'rrule' => '', ),
			array('id' => 26, 'is_variable' => false, 'month_day' => '1971-09-24', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1971-09-24', 'end_year' => '1971-09-24', 'rrule' => '', ),
			array('id' => 27, 'is_variable' => false, 'month_day' => '1972-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1972-09-23', 'end_year' => '1972-09-23', 'rrule' => '', ),
			array('id' => 28, 'is_variable' => false, 'month_day' => '1973-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1973-09-23', 'end_year' => '1973-09-23', 'rrule' => '', ),
			array('id' => 29, 'is_variable' => false, 'month_day' => '1970-10-10', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-10-10', 'end_year' => '1973-10-10', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=10;UNTIL=19731009T150000', ),
			array('id' => 30, 'is_variable' => false, 'month_day' => '1974-10-10', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-10-10', 'end_year' => '1999-10-10', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=10;UNTIL=19991009T150000', ),
			array('id' => 31, 'is_variable' => true, 'month_day' => '2000-10-09', 'week' => '2', 'day_of_the_week' => 'MO', 'can_substitute' => false, 'start_year' => '2000-10-09', 'end_year' => '2033-10-10', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=10;BYDAY=2MO;UNTIL=20331009T150000', ),
			array('id' => 32, 'is_variable' => false, 'month_day' => '1970-11-03', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-11-03', 'end_year' => '1973-11-03', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=11;UNTIL=19731102T150000', ),
			array('id' => 33, 'is_variable' => false, 'month_day' => '1974-11-03', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-11-03', 'end_year' => '2033-11-03', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=11;UNTIL=20331102T150000', ),
			array('id' => 34, 'is_variable' => false, 'month_day' => '1970-11-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1970-11-23', 'end_year' => '1973-11-23', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=11;UNTIL=19731122T150000', ),
			array('id' => 35, 'is_variable' => false, 'month_day' => '1974-11-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-11-23', 'end_year' => '2033-11-23', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=11;UNTIL=20331122T150000', ),
			array('id' => 36, 'is_variable' => false, 'month_day' => '1989-12-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1989-12-23', 'end_year' => '2033-12-23', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=12;UNTIL=20331222T150000', ),
			array('id' => 37, 'is_variable' => false, 'month_day' => '1975-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1975-03-21', 'end_year' => '1975-03-21', 'rrule' => '', ),
			array('id' => 38, 'is_variable' => false, 'month_day' => '1976-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1976-03-20', 'end_year' => '1976-03-20', 'rrule' => '', ),
			array('id' => 39, 'is_variable' => false, 'month_day' => '1977-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1977-03-21', 'end_year' => '1977-03-21', 'rrule' => '', ),
			array('id' => 40, 'is_variable' => false, 'month_day' => '1978-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1978-03-21', 'end_year' => '1978-03-21', 'rrule' => '', ),
			array('id' => 41, 'is_variable' => false, 'month_day' => '1979-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1979-03-21', 'end_year' => '1979-03-21', 'rrule' => '', ),
			array('id' => 42, 'is_variable' => false, 'month_day' => '1980-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1980-03-20', 'end_year' => '1980-03-20', 'rrule' => '', ),
			array('id' => 43, 'is_variable' => false, 'month_day' => '1981-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1981-03-21', 'end_year' => '1981-03-21', 'rrule' => '', ),
			array('id' => 44, 'is_variable' => false, 'month_day' => '1982-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1982-03-21', 'end_year' => '1982-03-21', 'rrule' => '', ),
			array('id' => 45, 'is_variable' => false, 'month_day' => '1983-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1983-03-21', 'end_year' => '1983-03-21', 'rrule' => '', ),
			array('id' => 46, 'is_variable' => false, 'month_day' => '1984-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1984-03-20', 'end_year' => '1984-03-20', 'rrule' => '', ),
			array('id' => 47, 'is_variable' => false, 'month_day' => '1985-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1985-03-21', 'end_year' => '1985-03-21', 'rrule' => '', ),
			array('id' => 48, 'is_variable' => false, 'month_day' => '1986-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1986-03-21', 'end_year' => '1986-03-21', 'rrule' => '', ),
			array('id' => 49, 'is_variable' => false, 'month_day' => '1987-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1987-03-21', 'end_year' => '1987-03-21', 'rrule' => '', ),
			array('id' => 50, 'is_variable' => false, 'month_day' => '1988-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1988-03-20', 'end_year' => '1988-03-20', 'rrule' => '', ),
			array('id' => 51, 'is_variable' => false, 'month_day' => '1989-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1989-03-21', 'end_year' => '1989-03-21', 'rrule' => '', ),
			array('id' => 52, 'is_variable' => false, 'month_day' => '1990-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1990-03-21', 'end_year' => '1990-03-21', 'rrule' => '', ),
			array('id' => 53, 'is_variable' => false, 'month_day' => '1991-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1991-03-21', 'end_year' => '1991-03-21', 'rrule' => '', ),
			array('id' => 54, 'is_variable' => false, 'month_day' => '1992-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1992-03-20', 'end_year' => '1992-03-20', 'rrule' => '', ),
			array('id' => 55, 'is_variable' => false, 'month_day' => '1993-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1993-03-20', 'end_year' => '1993-03-20', 'rrule' => '', ),
			array('id' => 56, 'is_variable' => false, 'month_day' => '1994-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1994-03-21', 'end_year' => '1994-03-21', 'rrule' => '', ),
			array('id' => 57, 'is_variable' => false, 'month_day' => '1995-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1995-03-21', 'end_year' => '1995-03-21', 'rrule' => '', ),
			array('id' => 58, 'is_variable' => false, 'month_day' => '1996-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1996-03-20', 'end_year' => '1996-03-20', 'rrule' => '', ),
			array('id' => 59, 'is_variable' => false, 'month_day' => '1997-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1997-03-20', 'end_year' => '1997-03-20', 'rrule' => '', ),
			array('id' => 60, 'is_variable' => false, 'month_day' => '1998-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1998-03-21', 'end_year' => '1998-03-21', 'rrule' => '', ),
			array('id' => 61, 'is_variable' => false, 'month_day' => '1999-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1999-03-21', 'end_year' => '1999-03-21', 'rrule' => '', ),
			array('id' => 62, 'is_variable' => false, 'month_day' => '2000-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2000-03-20', 'end_year' => '2000-03-20', 'rrule' => '', ),
			array('id' => 63, 'is_variable' => false, 'month_day' => '2001-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2001-03-20', 'end_year' => '2001-03-20', 'rrule' => '', ),
			array('id' => 64, 'is_variable' => false, 'month_day' => '2002-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2002-03-21', 'end_year' => '2002-03-21', 'rrule' => '', ),
			array('id' => 65, 'is_variable' => false, 'month_day' => '2003-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2003-03-21', 'end_year' => '2003-03-21', 'rrule' => '', ),
			array('id' => 66, 'is_variable' => false, 'month_day' => '2004-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2004-03-20', 'end_year' => '2004-03-20', 'rrule' => '', ),
			array('id' => 67, 'is_variable' => false, 'month_day' => '2005-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2005-03-20', 'end_year' => '2005-03-20', 'rrule' => '', ),
			array('id' => 68, 'is_variable' => false, 'month_day' => '2006-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2006-03-21', 'end_year' => '2006-03-21', 'rrule' => '', ),
			array('id' => 69, 'is_variable' => false, 'month_day' => '2007-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2007-03-21', 'end_year' => '2007-03-21', 'rrule' => '', ),
			array('id' => 70, 'is_variable' => false, 'month_day' => '2008-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2008-03-20', 'end_year' => '2008-03-20', 'rrule' => '', ),
			array('id' => 71, 'is_variable' => false, 'month_day' => '2009-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2009-03-20', 'end_year' => '2009-03-20', 'rrule' => '', ),
			array('id' => 72, 'is_variable' => false, 'month_day' => '2010-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2010-03-21', 'end_year' => '2010-03-21', 'rrule' => '', ),
			array('id' => 73, 'is_variable' => false, 'month_day' => '2011-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2011-03-21', 'end_year' => '2011-03-21', 'rrule' => '', ),
			array('id' => 74, 'is_variable' => false, 'month_day' => '2012-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2012-03-20', 'end_year' => '2012-03-20', 'rrule' => '', ),
			array('id' => 75, 'is_variable' => false, 'month_day' => '2013-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2013-03-20', 'end_year' => '2013-03-20', 'rrule' => '', ),
			array('id' => 76, 'is_variable' => false, 'month_day' => '2014-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2014-03-21', 'end_year' => '2014-03-21', 'rrule' => '', ),
			array('id' => 77, 'is_variable' => false, 'month_day' => '2015-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2015-03-21', 'end_year' => '2015-03-21', 'rrule' => '', ),
			array('id' => 78, 'is_variable' => false, 'month_day' => '2016-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2016-03-20', 'end_year' => '2016-03-20', 'rrule' => '', ),
			array('id' => 79, 'is_variable' => false, 'month_day' => '2017-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2017-03-20', 'end_year' => '2017-03-20', 'rrule' => '', ),
			array('id' => 80, 'is_variable' => false, 'month_day' => '2018-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2018-03-21', 'end_year' => '2018-03-21', 'rrule' => '', ),
			array('id' => 81, 'is_variable' => false, 'month_day' => '2019-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2019-03-21', 'end_year' => '2019-03-21', 'rrule' => '', ),
			array('id' => 82, 'is_variable' => false, 'month_day' => '2020-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2020-03-20', 'end_year' => '2020-03-20', 'rrule' => '', ),
			array('id' => 83, 'is_variable' => false, 'month_day' => '2021-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2021-03-20', 'end_year' => '2021-03-20', 'rrule' => '', ),
			array('id' => 84, 'is_variable' => false, 'month_day' => '2022-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2022-03-21', 'end_year' => '2022-03-21', 'rrule' => '', ),
			array('id' => 85, 'is_variable' => false, 'month_day' => '2023-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2023-03-21', 'end_year' => '2023-03-21', 'rrule' => '', ),
			array('id' => 86, 'is_variable' => false, 'month_day' => '2024-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2024-03-20', 'end_year' => '2024-03-20', 'rrule' => '', ),
			array('id' => 87, 'is_variable' => false, 'month_day' => '2025-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2025-03-20', 'end_year' => '2025-03-20', 'rrule' => '', ),
			array('id' => 88, 'is_variable' => false, 'month_day' => '2026-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2026-03-20', 'end_year' => '2026-03-20', 'rrule' => '', ),
			array('id' => 89, 'is_variable' => false, 'month_day' => '2027-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2027-03-21', 'end_year' => '2027-03-21', 'rrule' => '', ),
			array('id' => 90, 'is_variable' => false, 'month_day' => '2028-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2028-03-20', 'end_year' => '2028-03-20', 'rrule' => '', ),
			array('id' => 91, 'is_variable' => false, 'month_day' => '2029-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2029-03-20', 'end_year' => '2029-03-20', 'rrule' => '', ),
			array('id' => 92, 'is_variable' => false, 'month_day' => '2030-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2030-03-20', 'end_year' => '2030-03-20', 'rrule' => '', ),
			array('id' => 93, 'is_variable' => false, 'month_day' => '2031-03-21', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2031-03-21', 'end_year' => '2031-03-21', 'rrule' => '', ),
			array('id' => 94, 'is_variable' => false, 'month_day' => '2032-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2032-03-20', 'end_year' => '2032-03-20', 'rrule' => '', ),
			array('id' => 95, 'is_variable' => false, 'month_day' => '2033-03-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2033-03-20', 'end_year' => '2033-03-20', 'rrule' => '', ),
			array('id' => 96, 'is_variable' => false, 'month_day' => '1974-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1974-09-23', 'end_year' => '1974-09-23', 'rrule' => '', ),
			array('id' => 97, 'is_variable' => false, 'month_day' => '1975-09-24', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1975-09-24', 'end_year' => '1975-09-24', 'rrule' => '', ),
			array('id' => 98, 'is_variable' => false, 'month_day' => '1976-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1976-09-23', 'end_year' => '1976-09-23', 'rrule' => '', ),
			array('id' => 99, 'is_variable' => false, 'month_day' => '1977-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1977-09-23', 'end_year' => '1977-09-23', 'rrule' => '', ),
			array('id' => 100, 'is_variable' => false, 'month_day' => '1978-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1978-09-23', 'end_year' => '1978-09-23', 'rrule' => '', ),
			array('id' => 101, 'is_variable' => false, 'month_day' => '1979-09-24', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1979-09-24', 'end_year' => '1979-09-24', 'rrule' => '', ),
			array('id' => 102, 'is_variable' => false, 'month_day' => '1980-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1980-09-23', 'end_year' => '1980-09-23', 'rrule' => '', ),
			array('id' => 103, 'is_variable' => false, 'month_day' => '1981-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1981-09-23', 'end_year' => '1981-09-23', 'rrule' => '', ),
			array('id' => 104, 'is_variable' => false, 'month_day' => '1982-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1982-09-23', 'end_year' => '1982-09-23', 'rrule' => '', ),
			array('id' => 105, 'is_variable' => false, 'month_day' => '1983-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1983-09-23', 'end_year' => '1983-09-23', 'rrule' => '', ),
			array('id' => 106, 'is_variable' => false, 'month_day' => '1984-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1984-09-23', 'end_year' => '1984-09-23', 'rrule' => '', ),
			array('id' => 107, 'is_variable' => false, 'month_day' => '1985-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1985-09-23', 'end_year' => '1985-09-23', 'rrule' => '', ),
			array('id' => 108, 'is_variable' => false, 'month_day' => '1986-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1986-09-23', 'end_year' => '1986-09-23', 'rrule' => '', ),
			array('id' => 109, 'is_variable' => false, 'month_day' => '1987-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1987-09-23', 'end_year' => '1987-09-23', 'rrule' => '', ),
			array('id' => 110, 'is_variable' => false, 'month_day' => '1988-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1988-09-23', 'end_year' => '1988-09-23', 'rrule' => '', ),
			array('id' => 111, 'is_variable' => false, 'month_day' => '1989-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1989-09-23', 'end_year' => '1989-09-23', 'rrule' => '', ),
			array('id' => 112, 'is_variable' => false, 'month_day' => '1990-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1990-09-23', 'end_year' => '1990-09-23', 'rrule' => '', ),
			array('id' => 113, 'is_variable' => false, 'month_day' => '1991-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1991-09-23', 'end_year' => '1991-09-23', 'rrule' => '', ),
			array('id' => 114, 'is_variable' => false, 'month_day' => '1992-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1992-09-23', 'end_year' => '1992-09-23', 'rrule' => '', ),
			array('id' => 115, 'is_variable' => false, 'month_day' => '1993-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1993-09-23', 'end_year' => '1993-09-23', 'rrule' => '', ),
			array('id' => 116, 'is_variable' => false, 'month_day' => '1994-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1994-09-23', 'end_year' => '1994-09-23', 'rrule' => '', ),
			array('id' => 117, 'is_variable' => false, 'month_day' => '1995-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1995-09-23', 'end_year' => '1995-09-23', 'rrule' => '', ),
			array('id' => 118, 'is_variable' => false, 'month_day' => '1996-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1996-09-23', 'end_year' => '1996-09-23', 'rrule' => '', ),
			array('id' => 119, 'is_variable' => false, 'month_day' => '1997-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1997-09-23', 'end_year' => '1997-09-23', 'rrule' => '', ),
			array('id' => 120, 'is_variable' => false, 'month_day' => '1998-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1998-09-23', 'end_year' => '1998-09-23', 'rrule' => '', ),
			array('id' => 121, 'is_variable' => false, 'month_day' => '1999-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1999-09-23', 'end_year' => '1999-09-23', 'rrule' => '', ),
			array('id' => 122, 'is_variable' => false, 'month_day' => '2000-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2000-09-23', 'end_year' => '2000-09-23', 'rrule' => '', ),
			array('id' => 123, 'is_variable' => false, 'month_day' => '2001-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2001-09-23', 'end_year' => '2001-09-23', 'rrule' => '', ),
			array('id' => 124, 'is_variable' => false, 'month_day' => '2002-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2002-09-23', 'end_year' => '2002-09-23', 'rrule' => '', ),
			array('id' => 125, 'is_variable' => false, 'month_day' => '2003-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2003-09-23', 'end_year' => '2003-09-23', 'rrule' => '', ),
			array('id' => 126, 'is_variable' => false, 'month_day' => '2004-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2004-09-23', 'end_year' => '2004-09-23', 'rrule' => '', ),
			array('id' => 127, 'is_variable' => false, 'month_day' => '2005-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2005-09-23', 'end_year' => '2005-09-23', 'rrule' => '', ),
			array('id' => 128, 'is_variable' => false, 'month_day' => '2006-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2006-09-23', 'end_year' => '2006-09-23', 'rrule' => '', ),
			array('id' => 129, 'is_variable' => false, 'month_day' => '2007-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2007-09-23', 'end_year' => '2007-09-23', 'rrule' => '', ),
			array('id' => 130, 'is_variable' => false, 'month_day' => '2008-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2008-09-23', 'end_year' => '2008-09-23', 'rrule' => '', ),
			array('id' => 131, 'is_variable' => false, 'month_day' => '2009-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2009-09-23', 'end_year' => '2009-09-23', 'rrule' => '', ),
			array('id' => 132, 'is_variable' => false, 'month_day' => '2010-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2010-09-23', 'end_year' => '2010-09-23', 'rrule' => '', ),
			array('id' => 133, 'is_variable' => false, 'month_day' => '2011-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2011-09-23', 'end_year' => '2011-09-23', 'rrule' => '', ),
			array('id' => 134, 'is_variable' => false, 'month_day' => '2012-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2012-09-22', 'end_year' => '2012-09-22', 'rrule' => '', ),
			array('id' => 135, 'is_variable' => false, 'month_day' => '2013-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2013-09-23', 'end_year' => '2013-09-23', 'rrule' => '', ),
			array('id' => 136, 'is_variable' => false, 'month_day' => '2014-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2014-09-23', 'end_year' => '2014-09-23', 'rrule' => '', ),
			array('id' => 137, 'is_variable' => false, 'month_day' => '2015-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2015-09-23', 'end_year' => '2015-09-23', 'rrule' => '', ),
			array('id' => 138, 'is_variable' => false, 'month_day' => '2016-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2016-09-22', 'end_year' => '2016-09-22', 'rrule' => '', ),
			array('id' => 139, 'is_variable' => false, 'month_day' => '2017-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2017-09-23', 'end_year' => '2017-09-23', 'rrule' => '', ),
			array('id' => 140, 'is_variable' => false, 'month_day' => '2018-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2018-09-23', 'end_year' => '2018-09-23', 'rrule' => '', ),
			array('id' => 141, 'is_variable' => false, 'month_day' => '2019-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2019-09-23', 'end_year' => '2019-09-23', 'rrule' => '', ),
			array('id' => 142, 'is_variable' => false, 'month_day' => '2020-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2020-09-23', 'end_year' => '2020-09-23', 'rrule' => '', ),
			array('id' => 143, 'is_variable' => false, 'month_day' => '2021-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2021-09-23', 'end_year' => '2021-09-23', 'rrule' => '', ),
			array('id' => 144, 'is_variable' => false, 'month_day' => '2022-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2022-09-23', 'end_year' => '2022-09-23', 'rrule' => '', ),
			array('id' => 145, 'is_variable' => false, 'month_day' => '2023-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2023-09-23', 'end_year' => '2023-09-23', 'rrule' => '', ),
			array('id' => 146, 'is_variable' => false, 'month_day' => '2024-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2024-09-22', 'end_year' => '2024-09-22', 'rrule' => '', ),
			array('id' => 147, 'is_variable' => false, 'month_day' => '2025-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2025-09-23', 'end_year' => '2025-09-23', 'rrule' => '', ),
			array('id' => 148, 'is_variable' => false, 'month_day' => '2026-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2026-09-23', 'end_year' => '2026-09-23', 'rrule' => '', ),
			array('id' => 149, 'is_variable' => false, 'month_day' => '2027-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2027-09-23', 'end_year' => '2027-09-23', 'rrule' => '', ),
			array('id' => 150, 'is_variable' => false, 'month_day' => '2028-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2028-09-22', 'end_year' => '2028-09-22', 'rrule' => '', ),
			array('id' => 151, 'is_variable' => false, 'month_day' => '2029-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2029-09-23', 'end_year' => '2029-09-23', 'rrule' => '', ),
			array('id' => 152, 'is_variable' => false, 'month_day' => '2030-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2030-09-23', 'end_year' => '2030-09-23', 'rrule' => '', ),
			array('id' => 153, 'is_variable' => false, 'month_day' => '2031-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2031-09-23', 'end_year' => '2031-09-23', 'rrule' => '', ),
			array('id' => 154, 'is_variable' => false, 'month_day' => '2032-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2032-09-22', 'end_year' => '2032-09-22', 'rrule' => '', ),
			array('id' => 155, 'is_variable' => false, 'month_day' => '2033-09-23', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2033-09-23', 'end_year' => '2033-09-23', 'rrule' => '', ),
			array('id' => 156, 'is_variable' => false, 'month_day' => '1988-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1988-05-04', 'end_year' => '1988-05-04', 'rrule' => '', ),
			array('id' => 157, 'is_variable' => false, 'month_day' => '1989-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1989-05-04', 'end_year' => '1989-05-04', 'rrule' => '', ),
			array('id' => 158, 'is_variable' => false, 'month_day' => '1990-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1990-05-04', 'end_year' => '1990-05-04', 'rrule' => '', ),
			array('id' => 159, 'is_variable' => false, 'month_day' => '1991-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1991-05-04', 'end_year' => '1991-05-04', 'rrule' => '', ),
			array('id' => 160, 'is_variable' => false, 'month_day' => '1993-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1993-05-04', 'end_year' => '1993-05-04', 'rrule' => '', ),
			array('id' => 161, 'is_variable' => false, 'month_day' => '1994-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1994-05-04', 'end_year' => '1994-05-04', 'rrule' => '', ),
			array('id' => 162, 'is_variable' => false, 'month_day' => '1995-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1995-05-04', 'end_year' => '1995-05-04', 'rrule' => '', ),
			array('id' => 163, 'is_variable' => false, 'month_day' => '1996-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1996-05-04', 'end_year' => '1996-05-04', 'rrule' => '', ),
			array('id' => 164, 'is_variable' => false, 'month_day' => '1999-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '1999-05-04', 'end_year' => '1999-05-04', 'rrule' => '', ),
			array('id' => 165, 'is_variable' => false, 'month_day' => '2000-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2000-05-04', 'end_year' => '2000-05-04', 'rrule' => '', ),
			array('id' => 166, 'is_variable' => false, 'month_day' => '2001-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2001-05-04', 'end_year' => '2001-05-04', 'rrule' => '', ),
			array('id' => 167, 'is_variable' => false, 'month_day' => '2002-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2002-05-04', 'end_year' => '2002-05-04', 'rrule' => '', ),
			array('id' => 168, 'is_variable' => false, 'month_day' => '2004-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2004-05-04', 'end_year' => '2004-05-04', 'rrule' => '', ),
			array('id' => 169, 'is_variable' => false, 'month_day' => '2005-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2005-05-04', 'end_year' => '2005-05-04', 'rrule' => '', ),
			array('id' => 170, 'is_variable' => false, 'month_day' => '2006-05-04', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2006-05-04', 'end_year' => '2006-05-04', 'rrule' => '', ),
			array('id' => 171, 'is_variable' => false, 'month_day' => '1996-07-20', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '1996-07-20', 'end_year' => '2002-07-20', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=7;UNTIL=20020719T150000', ),
			array('id' => 172, 'is_variable' => true, 'month_day' => '2003-7-21', 'week' => '3', 'day_of_the_week' => 'MO', 'can_substitute' => false, 'start_year' => '2003-07-21', 'end_year' => '2033-07-18', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=7;BYDAY=3MO;UNTIL=20330717T150000', ),
			array('id' => 173, 'is_variable' => false, 'month_day' => '2015-09-22', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => false, 'start_year' => '2015-09-22', 'end_year' => '2015-09-22', 'rrule' => '', ),
			array('id' => 174, 'is_variable' => false, 'month_day' => '2016-08-11', 'week' => '0', 'day_of_the_week' => '', 'can_substitute' => true, 'start_year' => '2016-08-11', 'end_year' => '2033-08-11', 'rrule' => 'FREQ=YEARLY;INTERVAL=1;BYMONTH=8;UNTIL=20330811T150000', ),
		),
		'Holiday' => array(
			array('key' => 'holiday_1', 'holiday_rrule_id' => 1, 'language_id' => 2, 'holiday' => '1970-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_1', 'holiday_rrule_id' => 1, 'language_id' => 1, 'holiday' => '1970-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_2', 'holiday_rrule_id' => 1, 'language_id' => 2, 'holiday' => '1971-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_2', 'holiday_rrule_id' => 1, 'language_id' => 1, 'holiday' => '1971-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_3', 'holiday_rrule_id' => 1, 'language_id' => 2, 'holiday' => '1972-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_3', 'holiday_rrule_id' => 1, 'language_id' => 1, 'holiday' => '1972-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_4', 'holiday_rrule_id' => 1, 'language_id' => 2, 'holiday' => '1973-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_4', 'holiday_rrule_id' => 1, 'language_id' => 1, 'holiday' => '1973-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_5', 'holiday_rrule_id' => 1, 'language_id' => 2, 'holiday' => '1974-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_5', 'holiday_rrule_id' => 1, 'language_id' => 1, 'holiday' => '1974-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_6', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1975-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_6', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1975-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_7', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1976-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_7', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1976-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_8', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1977-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_8', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1977-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_9', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1978-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_9', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1978-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_10', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1978-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_10', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1978-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_11', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1979-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_11', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1979-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_12', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1980-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_12', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1980-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_13', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1981-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_13', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1981-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_14', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1982-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_14', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1982-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_15', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1983-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_15', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1983-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_16', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1984-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_16', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1984-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_17', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1984-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_17', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1984-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_18', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1985-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_18', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1985-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_19', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1986-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_19', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1986-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_20', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1987-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_20', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1987-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_21', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1988-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_21', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1988-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_22', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1989-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_22', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1989-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_23', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1989-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_23', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1989-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_24', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1990-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_24', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1990-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_25', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1991-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_25', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1991-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_26', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1992-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_26', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1992-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_27', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1993-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_27', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1993-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_28', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1994-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_28', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1994-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_29', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1995-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_29', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1995-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_30', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1995-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_30', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1995-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_31', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1996-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_31', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1996-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_32', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1997-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_32', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1997-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_33', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1998-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_33', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1998-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_34', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '1999-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_34', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '1999-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_35', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2000-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_35', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2000-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_36', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2001-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_36', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2001-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_37', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2002-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_37', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2002-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_38', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2003-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_38', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2003-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_39', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2004-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_39', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2004-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_40', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2005-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_40', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2005-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_41', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2006-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_41', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2006-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_42', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2006-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_42', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2006-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_43', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2007-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_43', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2007-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_44', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2008-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_44', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2008-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_45', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2009-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_45', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2009-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_46', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2010-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_46', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2010-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_47', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2011-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_47', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2011-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_48', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2012-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_48', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2012-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_49', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2012-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_49', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2012-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_50', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2013-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_50', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2013-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_51', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2014-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_51', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2014-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_52', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2015-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_52', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2015-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_53', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2016-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_53', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2016-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_54', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2017-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_54', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2017-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_55', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2017-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_55', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2017-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_56', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2018-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_56', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2018-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_57', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2019-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_57', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2019-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_58', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2020-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_58', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2020-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_59', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2021-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_59', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2021-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_60', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2022-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_60', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2022-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_61', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2023-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_61', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2023-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_62', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2023-01-02', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_62', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2023-01-02', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_63', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2024-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_63', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2024-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_64', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2025-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_64', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2025-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_65', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2026-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_65', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2026-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_66', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2027-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_66', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2027-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_67', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2028-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_67', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2028-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_68', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2029-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_68', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2029-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_69', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2030-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_69', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2030-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_70', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2031-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_70', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2031-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_71', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2032-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_71', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2032-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_72', 'holiday_rrule_id' => 2, 'language_id' => 2, 'holiday' => '2033-01-01', 'title' => '元日', 'is_substitute' => false, ),
			array('key' => 'holiday_72', 'holiday_rrule_id' => 2, 'language_id' => 1, 'holiday' => '2033-01-01', 'title' => 'New Year\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_73', 'holiday_rrule_id' => 3, 'language_id' => 2, 'holiday' => '1970-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_73', 'holiday_rrule_id' => 3, 'language_id' => 1, 'holiday' => '1970-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_74', 'holiday_rrule_id' => 3, 'language_id' => 2, 'holiday' => '1971-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_74', 'holiday_rrule_id' => 3, 'language_id' => 1, 'holiday' => '1971-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_75', 'holiday_rrule_id' => 3, 'language_id' => 2, 'holiday' => '1972-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_75', 'holiday_rrule_id' => 3, 'language_id' => 1, 'holiday' => '1972-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_76', 'holiday_rrule_id' => 3, 'language_id' => 2, 'holiday' => '1973-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_76', 'holiday_rrule_id' => 3, 'language_id' => 1, 'holiday' => '1973-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_77', 'holiday_rrule_id' => 3, 'language_id' => 2, 'holiday' => '1974-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_77', 'holiday_rrule_id' => 3, 'language_id' => 1, 'holiday' => '1974-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_78', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1975-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_78', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1975-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_79', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1976-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_79', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1976-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_80', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1977-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_80', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1977-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_81', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1978-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_81', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1978-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_82', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1978-01-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_82', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1978-01-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_83', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1979-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_83', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1979-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_84', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1980-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_84', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1980-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_85', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1981-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_85', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1981-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_86', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1982-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_86', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1982-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_87', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1983-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_87', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1983-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_88', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1984-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_88', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1984-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_89', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1984-01-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_89', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1984-01-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_90', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1985-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_90', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1985-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_91', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1986-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_91', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1986-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_92', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1987-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_92', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1987-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_93', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1988-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_93', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1988-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_94', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1989-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_94', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1989-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_95', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1989-01-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_95', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1989-01-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_96', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1990-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_96', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1990-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_97', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1991-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_97', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1991-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_98', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1992-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_98', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1992-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_99', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1993-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_99', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1993-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_100', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1994-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_100', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1994-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_101', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1995-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_101', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1995-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_102', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1995-01-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_102', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1995-01-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_103', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1996-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_103', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1996-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_104', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1997-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_104', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1997-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_105', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1998-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_105', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1998-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_106', 'holiday_rrule_id' => 4, 'language_id' => 2, 'holiday' => '1999-01-15', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_106', 'holiday_rrule_id' => 4, 'language_id' => 1, 'holiday' => '1999-01-15', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_107', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2000-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_107', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2000-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_108', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2001-01-08', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_108', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2001-01-08', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_109', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2002-01-14', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_109', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2002-01-14', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_110', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2003-01-13', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_110', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2003-01-13', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_111', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2004-01-12', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_111', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2004-01-12', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_112', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2005-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_112', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2005-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_113', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2006-01-09', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_113', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2006-01-09', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_114', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2007-01-08', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_114', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2007-01-08', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_115', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2008-01-14', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_115', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2008-01-14', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_116', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2009-01-12', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_116', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2009-01-12', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_117', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2010-01-11', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_117', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2010-01-11', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_118', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2011-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_118', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2011-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_119', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2012-01-09', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_119', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2012-01-09', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_120', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2013-01-14', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_120', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2013-01-14', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_121', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2014-01-13', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_121', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2014-01-13', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_122', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2015-01-12', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_122', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2015-01-12', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_123', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2016-01-11', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_123', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2016-01-11', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_124', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2017-01-09', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_124', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2017-01-09', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_125', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2018-01-08', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_125', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2018-01-08', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_126', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2019-01-14', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_126', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2019-01-14', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_127', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2020-01-13', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_127', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2020-01-13', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_128', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2021-01-11', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_128', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2021-01-11', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_129', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2022-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_129', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2022-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_130', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2023-01-09', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_130', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2023-01-09', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_131', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2024-01-08', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_131', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2024-01-08', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_132', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2025-01-13', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_132', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2025-01-13', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_133', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2026-01-12', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_133', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2026-01-12', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_134', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2027-01-11', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_134', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2027-01-11', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_135', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2028-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_135', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2028-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_136', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2029-01-08', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_136', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2029-01-08', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_137', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2030-01-14', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_137', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2030-01-14', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_138', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2031-01-13', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_138', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2031-01-13', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_139', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2032-01-12', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_139', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2032-01-12', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_140', 'holiday_rrule_id' => 5, 'language_id' => 2, 'holiday' => '2033-01-10', 'title' => '成人の日', 'is_substitute' => false, ),
			array('key' => 'holiday_140', 'holiday_rrule_id' => 5, 'language_id' => 1, 'holiday' => '2033-01-10', 'title' => 'Coming-of-Age Day', 'is_substitute' => false, ),
			array('key' => 'holiday_141', 'holiday_rrule_id' => 6, 'language_id' => 2, 'holiday' => '1970-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_141', 'holiday_rrule_id' => 6, 'language_id' => 1, 'holiday' => '1970-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_142', 'holiday_rrule_id' => 6, 'language_id' => 2, 'holiday' => '1971-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_142', 'holiday_rrule_id' => 6, 'language_id' => 1, 'holiday' => '1971-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_143', 'holiday_rrule_id' => 6, 'language_id' => 2, 'holiday' => '1972-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_143', 'holiday_rrule_id' => 6, 'language_id' => 1, 'holiday' => '1972-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_144', 'holiday_rrule_id' => 6, 'language_id' => 2, 'holiday' => '1973-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_144', 'holiday_rrule_id' => 6, 'language_id' => 1, 'holiday' => '1973-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_145', 'holiday_rrule_id' => 6, 'language_id' => 2, 'holiday' => '1974-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_145', 'holiday_rrule_id' => 6, 'language_id' => 1, 'holiday' => '1974-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_146', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1975-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_146', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1975-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_147', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1976-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_147', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1976-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_148', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1977-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_148', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1977-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_149', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1978-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_149', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1978-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_150', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1979-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_150', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1979-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_151', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1979-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_151', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1979-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_152', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1980-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_152', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1980-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_153', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1981-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_153', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1981-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_154', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1982-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_154', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1982-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_155', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1983-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_155', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1983-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_156', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1984-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_156', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1984-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_157', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1985-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_157', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1985-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_158', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1986-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_158', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1986-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_159', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1987-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_159', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1987-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_160', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1988-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_160', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1988-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_161', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1989-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_161', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1989-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_162', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1990-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_162', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1990-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_163', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1990-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_163', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1990-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_164', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1991-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_164', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1991-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_165', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1992-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_165', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1992-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_166', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1993-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_166', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1993-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_167', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1994-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_167', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1994-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_168', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1995-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_168', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1995-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_169', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1996-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_169', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1996-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_170', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1996-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_170', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1996-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_171', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1997-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_171', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1997-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_172', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1998-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_172', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1998-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_173', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '1999-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_173', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '1999-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_174', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2000-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_174', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2000-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_175', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2001-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_175', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2001-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_176', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2001-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_176', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2001-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_177', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2002-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_177', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2002-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_178', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2003-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_178', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2003-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_179', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2004-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_179', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2004-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_180', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2005-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_180', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2005-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_181', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2006-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_181', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2006-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_182', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2007-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_182', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2007-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_183', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2007-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_183', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2007-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_184', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2008-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_184', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2008-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_185', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2009-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_185', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2009-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_186', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2010-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_186', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2010-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_187', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2011-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_187', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2011-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_188', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2012-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_188', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2012-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_189', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2013-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_189', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2013-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_190', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2014-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_190', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2014-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_191', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2015-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_191', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2015-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_192', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2016-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_192', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2016-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_193', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2017-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_193', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2017-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_194', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2018-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_194', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2018-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_195', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2018-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_195', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2018-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_196', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2019-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_196', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2019-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_197', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2020-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_197', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2020-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_198', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2021-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_198', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2021-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_199', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2022-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_199', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2022-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_200', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2023-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_200', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2023-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_201', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2024-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_201', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2024-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_202', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2024-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_202', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2024-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_203', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2025-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_203', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2025-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_204', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2026-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_204', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2026-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_205', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2027-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_205', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2027-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_206', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2028-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_206', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2028-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_207', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2029-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_207', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2029-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_208', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2029-02-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_208', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2029-02-12', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_209', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2030-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_209', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2030-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_210', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2031-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_210', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2031-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_211', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2032-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_211', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2032-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_212', 'holiday_rrule_id' => 7, 'language_id' => 2, 'holiday' => '2033-02-11', 'title' => '建国記念の日', 'is_substitute' => false, ),
			array('key' => 'holiday_212', 'holiday_rrule_id' => 7, 'language_id' => 1, 'holiday' => '2033-02-11', 'title' => 'Foundation Day', 'is_substitute' => false, ),
			array('key' => 'holiday_213', 'holiday_rrule_id' => 8, 'language_id' => 2, 'holiday' => '1970-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_213', 'holiday_rrule_id' => 8, 'language_id' => 1, 'holiday' => '1970-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_214', 'holiday_rrule_id' => 9, 'language_id' => 2, 'holiday' => '1971-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_214', 'holiday_rrule_id' => 9, 'language_id' => 1, 'holiday' => '1971-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_215', 'holiday_rrule_id' => 10, 'language_id' => 2, 'holiday' => '1972-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_215', 'holiday_rrule_id' => 10, 'language_id' => 1, 'holiday' => '1972-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_216', 'holiday_rrule_id' => 11, 'language_id' => 2, 'holiday' => '1973-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_216', 'holiday_rrule_id' => 11, 'language_id' => 1, 'holiday' => '1973-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_217', 'holiday_rrule_id' => 12, 'language_id' => 2, 'holiday' => '1974-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_217', 'holiday_rrule_id' => 12, 'language_id' => 1, 'holiday' => '1974-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_218', 'holiday_rrule_id' => 13, 'language_id' => 2, 'holiday' => '1970-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_218', 'holiday_rrule_id' => 13, 'language_id' => 1, 'holiday' => '1970-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_219', 'holiday_rrule_id' => 13, 'language_id' => 2, 'holiday' => '1971-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_219', 'holiday_rrule_id' => 13, 'language_id' => 1, 'holiday' => '1971-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_220', 'holiday_rrule_id' => 13, 'language_id' => 2, 'holiday' => '1972-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_220', 'holiday_rrule_id' => 13, 'language_id' => 1, 'holiday' => '1972-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_221', 'holiday_rrule_id' => 13, 'language_id' => 2, 'holiday' => '1973-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_221', 'holiday_rrule_id' => 13, 'language_id' => 1, 'holiday' => '1973-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_222', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1974-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_222', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1974-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_223', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1975-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_223', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1975-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_224', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1976-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_224', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1976-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_225', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1977-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_225', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1977-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_226', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1978-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_226', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1978-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_227', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1979-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_227', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1979-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_228', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1979-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_228', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1979-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_229', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1980-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_229', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1980-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_230', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1981-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_230', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1981-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_231', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1982-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_231', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1982-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_232', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1983-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_232', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1983-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_233', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1984-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_233', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1984-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_234', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1984-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_234', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1984-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_235', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1985-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_235', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1985-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_236', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1986-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_236', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1986-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_237', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1987-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_237', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1987-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_238', 'holiday_rrule_id' => 14, 'language_id' => 2, 'holiday' => '1988-04-29', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_238', 'holiday_rrule_id' => 14, 'language_id' => 1, 'holiday' => '1988-04-29', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_239', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1989-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_239', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1989-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_240', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1990-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_240', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1990-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_241', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1990-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_241', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1990-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_242', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1991-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_242', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1991-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_243', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1992-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_243', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1992-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_244', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1993-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_244', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1993-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_245', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1994-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_245', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1994-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_246', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1995-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_246', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1995-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_247', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1996-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_247', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1996-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_248', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1997-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_248', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1997-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_249', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1998-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_249', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1998-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_250', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '1999-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_250', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '1999-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_251', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2000-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_251', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2000-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_252', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2001-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_252', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2001-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_253', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2001-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_253', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2001-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_254', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2002-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_254', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2002-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_255', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2003-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_255', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2003-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_256', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2004-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_256', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2004-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_257', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2005-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_257', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2005-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_258', 'holiday_rrule_id' => 15, 'language_id' => 2, 'holiday' => '2006-04-29', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_258', 'holiday_rrule_id' => 15, 'language_id' => 1, 'holiday' => '2006-04-29', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_259', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2007-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_259', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2007-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_260', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2007-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_260', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2007-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_261', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2008-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_261', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2008-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_262', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2009-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_262', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2009-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_263', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2010-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_263', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2010-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_264', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2011-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_264', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2011-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_265', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2012-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_265', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2012-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_266', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2012-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_266', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2012-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_267', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2013-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_267', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2013-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_268', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2014-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_268', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2014-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_269', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2015-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_269', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2015-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_270', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2016-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_270', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2016-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_271', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2017-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_271', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2017-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_272', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2018-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_272', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2018-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_273', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2018-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_273', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2018-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_274', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2019-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_274', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2019-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_275', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2020-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_275', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2020-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_276', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2021-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_276', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2021-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_277', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2022-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_277', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2022-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_278', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2023-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_278', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2023-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_279', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2024-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_279', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2024-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_280', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2025-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_280', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2025-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_281', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2026-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_281', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2026-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_282', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2027-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_282', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2027-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_283', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2028-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_283', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2028-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_284', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2029-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_284', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2029-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_285', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2029-04-30', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_285', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2029-04-30', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_286', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2030-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_286', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2030-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_287', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2031-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_287', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2031-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_288', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2032-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_288', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2032-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_289', 'holiday_rrule_id' => 16, 'language_id' => 2, 'holiday' => '2033-04-29', 'title' => '昭和の日', 'is_substitute' => false, ),
			array('key' => 'holiday_289', 'holiday_rrule_id' => 16, 'language_id' => 1, 'holiday' => '2033-04-29', 'title' => 'Showa Day', 'is_substitute' => false, ),
			array('key' => 'holiday_290', 'holiday_rrule_id' => 17, 'language_id' => 2, 'holiday' => '1970-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_290', 'holiday_rrule_id' => 17, 'language_id' => 1, 'holiday' => '1970-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_291', 'holiday_rrule_id' => 17, 'language_id' => 2, 'holiday' => '1971-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_291', 'holiday_rrule_id' => 17, 'language_id' => 1, 'holiday' => '1971-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_292', 'holiday_rrule_id' => 17, 'language_id' => 2, 'holiday' => '1972-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_292', 'holiday_rrule_id' => 17, 'language_id' => 1, 'holiday' => '1972-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_293', 'holiday_rrule_id' => 17, 'language_id' => 2, 'holiday' => '1973-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_293', 'holiday_rrule_id' => 17, 'language_id' => 1, 'holiday' => '1973-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_294', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1974-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_294', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1974-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_295', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1975-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_295', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1975-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_296', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1976-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_296', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1976-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_297', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1977-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_297', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1977-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_298', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1978-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_298', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1978-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_299', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1979-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_299', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1979-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_300', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1980-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_300', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1980-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_301', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1981-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_301', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1981-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_302', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1981-05-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_302', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1981-05-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_303', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1982-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_303', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1982-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_304', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1983-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_304', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1983-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_305', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1984-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_305', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1984-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_306', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1985-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_306', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1985-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_307', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1986-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_307', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1986-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_308', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1987-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_308', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1987-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_309', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1987-05-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_309', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1987-05-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_310', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1988-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_310', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1988-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_311', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1989-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_311', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1989-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_312', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1990-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_312', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1990-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_313', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1991-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_313', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1991-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_314', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1992-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_314', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1992-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_315', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1992-05-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_315', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1992-05-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_316', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1993-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_316', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1993-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_317', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1994-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_317', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1994-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_318', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1995-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_318', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1995-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_319', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1996-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_319', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1996-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_320', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1997-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_320', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1997-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_321', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1998-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_321', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1998-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_322', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1998-05-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_322', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1998-05-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_323', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '1999-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_323', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '1999-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_324', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2000-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_324', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2000-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_325', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2001-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_325', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2001-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_326', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2002-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_326', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2002-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_327', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2003-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_327', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2003-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_328', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2004-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_328', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2004-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_329', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2005-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_329', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2005-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_330', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2006-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_330', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2006-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_331', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2007-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_331', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2007-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_332', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2008-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_332', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2008-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_333', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2009-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_333', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2009-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_334', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2009-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_334', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2009-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_335', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2010-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_335', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2010-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_336', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2011-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_336', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2011-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_337', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2012-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_337', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2012-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_338', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2013-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_338', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2013-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_339', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2014-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_339', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2014-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_340', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2015-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_340', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2015-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_341', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2015-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_341', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2015-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_342', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2016-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_342', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2016-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_343', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2017-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_343', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2017-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_344', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2018-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_344', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2018-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_345', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2019-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_345', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2019-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_346', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2020-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_346', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2020-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_347', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2020-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_347', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2020-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_348', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2021-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_348', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2021-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_349', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2022-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_349', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2022-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_350', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2023-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_350', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2023-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_351', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2024-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_351', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2024-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_352', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2025-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_352', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2025-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_353', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2026-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_353', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2026-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_354', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2026-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_354', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2026-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_355', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2027-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_355', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2027-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_356', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2028-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_356', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2028-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_357', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2029-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_357', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2029-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_358', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2030-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_358', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2030-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_359', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2031-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_359', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2031-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_360', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2032-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_360', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2032-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_361', 'holiday_rrule_id' => 18, 'language_id' => 2, 'holiday' => '2033-05-03', 'title' => '憲法記念日', 'is_substitute' => false, ),
			array('key' => 'holiday_361', 'holiday_rrule_id' => 18, 'language_id' => 1, 'holiday' => '2033-05-03', 'title' => 'Constitution Day', 'is_substitute' => false, ),
			array('key' => 'holiday_362', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2007-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_362', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2007-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_363', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2008-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_363', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2008-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_364', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2008-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_364', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2008-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_365', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2009-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_365', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2009-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_366', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2010-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_366', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2010-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_367', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2011-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_367', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2011-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_368', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2012-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_368', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2012-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_369', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2013-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_369', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2013-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_370', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2014-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_370', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2014-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_371', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2014-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_371', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2014-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_372', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2015-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_372', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2015-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_373', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2016-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_373', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2016-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_374', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2017-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_374', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2017-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_375', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2018-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_375', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2018-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_376', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2019-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_376', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2019-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_377', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2020-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_377', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2020-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_378', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2021-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_378', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2021-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_379', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2022-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_379', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2022-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_380', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2023-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_380', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2023-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_381', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2024-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_381', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2024-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_382', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2025-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_382', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2025-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_383', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2025-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_383', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2025-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_384', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2026-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_384', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2026-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_385', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2027-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_385', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2027-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_386', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2028-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_386', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2028-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_387', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2029-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_387', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2029-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_388', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2030-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_388', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2030-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_389', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2031-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_389', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2031-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_390', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2031-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_390', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2031-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_391', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2032-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_391', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2032-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_392', 'holiday_rrule_id' => 19, 'language_id' => 2, 'holiday' => '2033-05-04', 'title' => 'みどりの日', 'is_substitute' => false, ),
			array('key' => 'holiday_392', 'holiday_rrule_id' => 19, 'language_id' => 1, 'holiday' => '2033-05-04', 'title' => 'Greenery Day', 'is_substitute' => false, ),
			array('key' => 'holiday_393', 'holiday_rrule_id' => 20, 'language_id' => 2, 'holiday' => '1970-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_393', 'holiday_rrule_id' => 20, 'language_id' => 1, 'holiday' => '1970-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_394', 'holiday_rrule_id' => 20, 'language_id' => 2, 'holiday' => '1971-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_394', 'holiday_rrule_id' => 20, 'language_id' => 1, 'holiday' => '1971-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_395', 'holiday_rrule_id' => 20, 'language_id' => 2, 'holiday' => '1972-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_395', 'holiday_rrule_id' => 20, 'language_id' => 1, 'holiday' => '1972-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_396', 'holiday_rrule_id' => 20, 'language_id' => 2, 'holiday' => '1973-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_396', 'holiday_rrule_id' => 20, 'language_id' => 1, 'holiday' => '1973-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_397', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1974-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_397', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1974-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_398', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1974-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_398', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1974-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_399', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1975-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_399', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1975-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_400', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1976-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_400', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1976-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_401', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1977-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_401', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1977-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_402', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1978-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_402', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1978-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_403', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1979-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_403', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1979-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_404', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1980-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_404', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1980-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_405', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1981-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_405', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1981-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_406', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1982-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_406', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1982-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_407', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1983-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_407', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1983-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_408', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1984-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_408', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1984-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_409', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1985-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_409', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1985-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_410', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1985-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_410', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1985-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_411', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1986-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_411', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1986-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_412', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1987-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_412', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1987-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_413', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1988-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_413', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1988-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_414', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1989-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_414', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1989-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_415', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1990-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_415', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1990-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_416', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1991-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_416', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1991-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_417', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1991-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_417', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1991-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_418', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1992-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_418', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1992-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_419', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1993-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_419', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1993-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_420', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1994-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_420', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1994-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_421', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1995-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_421', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1995-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_422', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1996-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_422', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1996-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_423', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1996-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_423', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1996-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_424', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1997-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_424', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1997-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_425', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1998-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_425', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1998-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_426', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '1999-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_426', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '1999-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_427', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2000-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_427', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2000-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_428', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2001-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_428', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2001-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_429', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2002-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_429', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2002-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_430', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2002-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_430', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2002-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_431', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2003-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_431', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2003-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_432', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2004-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_432', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2004-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_433', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2005-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_433', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2005-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_434', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2006-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_434', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2006-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_435', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2007-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_435', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2007-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_436', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2008-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_436', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2008-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_437', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2009-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_437', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2009-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_438', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2010-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_438', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2010-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_439', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2011-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_439', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2011-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_440', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2012-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_440', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2012-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_441', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2013-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_441', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2013-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_442', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2013-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_442', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2013-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_443', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2014-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_443', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2014-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_444', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2015-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_444', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2015-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_445', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2016-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_445', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2016-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_446', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2017-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_446', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2017-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_447', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2018-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_447', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2018-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_448', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2019-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_448', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2019-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_449', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2019-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_449', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2019-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_450', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2020-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_450', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2020-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_451', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2021-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_451', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2021-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_452', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2022-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_452', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2022-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_453', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2023-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_453', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2023-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_454', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2024-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_454', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2024-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_455', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2024-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_455', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2024-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_456', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2025-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_456', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2025-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_457', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2026-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_457', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2026-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_458', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2027-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_458', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2027-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_459', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2028-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_459', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2028-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_460', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2029-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_460', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2029-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_461', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2030-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_461', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2030-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_462', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2030-05-06', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_462', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2030-05-06', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_463', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2031-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_463', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2031-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_464', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2032-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_464', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2032-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_465', 'holiday_rrule_id' => 21, 'language_id' => 2, 'holiday' => '2033-05-05', 'title' => 'こどもの日', 'is_substitute' => false, ),
			array('key' => 'holiday_465', 'holiday_rrule_id' => 21, 'language_id' => 1, 'holiday' => '2033-05-05', 'title' => 'Children\'s Day', 'is_substitute' => false, ),
			array('key' => 'holiday_466', 'holiday_rrule_id' => 22, 'language_id' => 2, 'holiday' => '1970-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_466', 'holiday_rrule_id' => 22, 'language_id' => 1, 'holiday' => '1970-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_467', 'holiday_rrule_id' => 22, 'language_id' => 2, 'holiday' => '1971-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_467', 'holiday_rrule_id' => 22, 'language_id' => 1, 'holiday' => '1971-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_468', 'holiday_rrule_id' => 22, 'language_id' => 2, 'holiday' => '1972-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_468', 'holiday_rrule_id' => 22, 'language_id' => 1, 'holiday' => '1972-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_469', 'holiday_rrule_id' => 22, 'language_id' => 2, 'holiday' => '1973-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_469', 'holiday_rrule_id' => 22, 'language_id' => 1, 'holiday' => '1973-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_470', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1974-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_470', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1974-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_471', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1974-09-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_471', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1974-09-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_472', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1975-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_472', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1975-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_473', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1976-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_473', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1976-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_474', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1977-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_474', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1977-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_475', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1978-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_475', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1978-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_476', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1979-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_476', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1979-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_477', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1980-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_477', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1980-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_478', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1981-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_478', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1981-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_479', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1982-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_479', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1982-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_480', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1983-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_480', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1983-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_481', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1984-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_481', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1984-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_482', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1985-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_482', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1985-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_483', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1985-09-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_483', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1985-09-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_484', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1986-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_484', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1986-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_485', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1987-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_485', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1987-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_486', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1988-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_486', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1988-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_487', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1989-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_487', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1989-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_488', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1990-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_488', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1990-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_489', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1991-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_489', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1991-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_490', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1991-09-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_490', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1991-09-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_491', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1992-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_491', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1992-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_492', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1993-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_492', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1993-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_493', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1994-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_493', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1994-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_494', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1995-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_494', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1995-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_495', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1996-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_495', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1996-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_496', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1996-09-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_496', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1996-09-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_497', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1997-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_497', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1997-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_498', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1998-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_498', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1998-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_499', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '1999-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_499', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '1999-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_500', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '2000-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_500', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '2000-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_501', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '2001-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_501', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '2001-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_502', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '2002-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_502', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '2002-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_503', 'holiday_rrule_id' => 23, 'language_id' => 2, 'holiday' => '2002-09-16', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_503', 'holiday_rrule_id' => 23, 'language_id' => 1, 'holiday' => '2002-09-16', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_504', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2003-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_504', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2003-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_505', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2004-09-20', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_505', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2004-09-20', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_506', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2005-09-19', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_506', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2005-09-19', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_507', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2006-09-18', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_507', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2006-09-18', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_508', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2007-09-17', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_508', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2007-09-17', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_509', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2008-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_509', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2008-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_510', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2009-09-21', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_510', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2009-09-21', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_511', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2010-09-20', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_511', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2010-09-20', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_512', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2011-09-19', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_512', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2011-09-19', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_513', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2012-09-17', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_513', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2012-09-17', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_514', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2013-09-16', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_514', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2013-09-16', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_515', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2014-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_515', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2014-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_516', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2015-09-21', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_516', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2015-09-21', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_517', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2016-09-19', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_517', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2016-09-19', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_518', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2017-09-18', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_518', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2017-09-18', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_519', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2018-09-17', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_519', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2018-09-17', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_520', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2019-09-16', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_520', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2019-09-16', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_521', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2020-09-21', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_521', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2020-09-21', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_522', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2021-09-20', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_522', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2021-09-20', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_523', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2022-09-19', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_523', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2022-09-19', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_524', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2023-09-18', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_524', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2023-09-18', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_525', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2024-09-16', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_525', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2024-09-16', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_526', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2025-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_526', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2025-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_527', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2026-09-21', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_527', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2026-09-21', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_528', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2027-09-20', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_528', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2027-09-20', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_529', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2028-09-18', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_529', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2028-09-18', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_530', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2029-09-17', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_530', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2029-09-17', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_531', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2030-09-16', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_531', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2030-09-16', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_532', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2031-09-15', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_532', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2031-09-15', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_533', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2032-09-20', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_533', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2032-09-20', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_534', 'holiday_rrule_id' => 24, 'language_id' => 2, 'holiday' => '2033-09-19', 'title' => '敬老の日', 'is_substitute' => false, ),
			array('key' => 'holiday_534', 'holiday_rrule_id' => 24, 'language_id' => 1, 'holiday' => '2033-09-19', 'title' => 'Respect-for-the-Aged Day', 'is_substitute' => false, ),
			array('key' => 'holiday_535', 'holiday_rrule_id' => 25, 'language_id' => 2, 'holiday' => '1970-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_535', 'holiday_rrule_id' => 25, 'language_id' => 1, 'holiday' => '1970-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_536', 'holiday_rrule_id' => 26, 'language_id' => 2, 'holiday' => '1971-09-24', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_536', 'holiday_rrule_id' => 26, 'language_id' => 1, 'holiday' => '1971-09-24', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_537', 'holiday_rrule_id' => 27, 'language_id' => 2, 'holiday' => '1972-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_537', 'holiday_rrule_id' => 27, 'language_id' => 1, 'holiday' => '1972-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_538', 'holiday_rrule_id' => 28, 'language_id' => 2, 'holiday' => '1973-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_538', 'holiday_rrule_id' => 28, 'language_id' => 1, 'holiday' => '1973-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_539', 'holiday_rrule_id' => 29, 'language_id' => 2, 'holiday' => '1970-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_539', 'holiday_rrule_id' => 29, 'language_id' => 1, 'holiday' => '1970-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_540', 'holiday_rrule_id' => 29, 'language_id' => 2, 'holiday' => '1971-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_540', 'holiday_rrule_id' => 29, 'language_id' => 1, 'holiday' => '1971-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_541', 'holiday_rrule_id' => 29, 'language_id' => 2, 'holiday' => '1972-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_541', 'holiday_rrule_id' => 29, 'language_id' => 1, 'holiday' => '1972-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_542', 'holiday_rrule_id' => 29, 'language_id' => 2, 'holiday' => '1973-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_542', 'holiday_rrule_id' => 29, 'language_id' => 1, 'holiday' => '1973-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_543', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1974-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_543', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1974-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_544', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1975-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_544', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1975-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_545', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1976-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_545', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1976-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_546', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1976-10-11', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_546', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1976-10-11', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_547', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1977-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_547', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1977-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_548', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1978-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_548', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1978-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_549', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1979-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_549', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1979-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_550', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1980-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_550', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1980-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_551', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1981-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_551', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1981-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_552', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1982-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_552', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1982-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_553', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1982-10-11', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_553', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1982-10-11', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_554', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1983-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_554', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1983-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_555', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1984-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_555', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1984-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_556', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1985-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_556', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1985-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_557', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1986-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_557', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1986-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_558', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1987-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_558', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1987-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_559', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1988-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_559', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1988-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_560', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1989-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_560', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1989-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_561', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1990-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_561', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1990-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_562', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1991-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_562', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1991-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_563', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1992-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_563', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1992-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_564', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1993-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_564', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1993-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_565', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1993-10-11', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_565', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1993-10-11', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_566', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1994-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_566', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1994-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_567', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1995-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_567', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1995-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_568', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1996-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_568', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1996-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_569', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1997-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_569', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1997-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_570', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1998-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_570', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1998-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_571', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1999-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_571', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1999-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_572', 'holiday_rrule_id' => 30, 'language_id' => 2, 'holiday' => '1999-10-11', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_572', 'holiday_rrule_id' => 30, 'language_id' => 1, 'holiday' => '1999-10-11', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_573', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2000-10-09', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_573', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2000-10-09', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_574', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2001-10-08', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_574', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2001-10-08', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_575', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2002-10-14', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_575', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2002-10-14', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_576', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2003-10-13', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_576', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2003-10-13', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_577', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2004-10-11', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_577', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2004-10-11', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_578', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2005-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_578', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2005-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_579', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2006-10-09', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_579', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2006-10-09', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_580', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2007-10-08', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_580', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2007-10-08', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_581', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2008-10-13', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_581', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2008-10-13', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_582', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2009-10-12', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_582', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2009-10-12', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_583', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2010-10-11', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_583', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2010-10-11', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_584', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2011-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_584', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2011-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_585', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2012-10-08', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_585', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2012-10-08', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_586', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2013-10-14', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_586', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2013-10-14', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_587', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2014-10-13', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_587', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2014-10-13', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_588', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2015-10-12', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_588', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2015-10-12', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_589', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2016-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_589', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2016-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_590', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2017-10-09', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_590', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2017-10-09', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_591', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2018-10-08', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_591', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2018-10-08', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_592', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2019-10-14', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_592', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2019-10-14', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_593', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2020-10-12', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_593', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2020-10-12', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_594', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2021-10-11', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_594', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2021-10-11', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_595', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2022-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_595', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2022-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_596', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2023-10-09', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_596', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2023-10-09', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_597', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2024-10-14', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_597', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2024-10-14', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_598', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2025-10-13', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_598', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2025-10-13', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_599', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2026-10-12', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_599', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2026-10-12', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_600', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2027-10-11', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_600', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2027-10-11', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_601', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2028-10-09', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_601', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2028-10-09', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_602', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2029-10-08', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_602', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2029-10-08', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_603', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2030-10-14', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_603', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2030-10-14', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_604', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2031-10-13', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_604', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2031-10-13', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_605', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2032-10-11', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_605', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2032-10-11', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_606', 'holiday_rrule_id' => 31, 'language_id' => 2, 'holiday' => '2033-10-10', 'title' => '体育の日', 'is_substitute' => false, ),
			array('key' => 'holiday_606', 'holiday_rrule_id' => 31, 'language_id' => 1, 'holiday' => '2033-10-10', 'title' => 'Sports Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_607', 'holiday_rrule_id' => 32, 'language_id' => 2, 'holiday' => '1970-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_607', 'holiday_rrule_id' => 32, 'language_id' => 1, 'holiday' => '1970-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_608', 'holiday_rrule_id' => 32, 'language_id' => 2, 'holiday' => '1971-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_608', 'holiday_rrule_id' => 32, 'language_id' => 1, 'holiday' => '1971-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_609', 'holiday_rrule_id' => 32, 'language_id' => 2, 'holiday' => '1972-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_609', 'holiday_rrule_id' => 32, 'language_id' => 1, 'holiday' => '1972-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_610', 'holiday_rrule_id' => 32, 'language_id' => 2, 'holiday' => '1973-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_610', 'holiday_rrule_id' => 32, 'language_id' => 1, 'holiday' => '1973-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_611', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1974-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_611', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1974-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_612', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1974-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_612', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1974-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_613', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1975-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_613', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1975-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_614', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1976-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_614', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1976-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_615', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1977-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_615', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1977-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_616', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1978-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_616', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1978-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_617', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1979-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_617', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1979-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_618', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1980-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_618', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1980-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_619', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1981-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_619', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1981-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_620', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1982-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_620', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1982-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_621', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1983-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_621', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1983-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_622', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1984-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_622', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1984-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_623', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1985-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_623', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1985-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_624', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1985-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_624', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1985-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_625', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1986-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_625', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1986-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_626', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1987-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_626', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1987-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_627', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1988-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_627', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1988-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_628', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1989-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_628', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1989-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_629', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1990-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_629', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1990-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_630', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1991-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_630', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1991-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_631', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1991-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_631', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1991-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_632', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1992-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_632', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1992-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_633', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1993-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_633', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1993-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_634', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1994-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_634', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1994-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_635', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1995-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_635', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1995-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_636', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1996-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_636', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1996-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_637', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1996-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_637', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1996-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_638', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1997-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_638', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1997-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_639', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1998-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_639', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1998-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_640', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '1999-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_640', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '1999-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_641', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2000-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_641', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2000-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_642', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2001-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_642', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2001-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_643', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2002-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_643', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2002-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_644', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2002-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_644', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2002-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_645', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2003-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_645', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2003-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_646', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2004-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_646', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2004-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_647', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2005-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_647', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2005-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_648', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2006-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_648', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2006-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_649', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2007-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_649', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2007-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_650', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2008-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_650', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2008-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_651', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2009-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_651', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2009-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_652', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2010-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_652', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2010-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_653', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2011-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_653', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2011-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_654', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2012-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_654', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2012-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_655', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2013-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_655', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2013-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_656', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2013-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_656', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2013-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_657', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2014-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_657', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2014-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_658', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2015-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_658', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2015-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_659', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2016-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_659', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2016-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_660', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2017-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_660', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2017-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_661', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2018-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_661', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2018-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_662', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2019-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_662', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2019-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_663', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2019-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_663', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2019-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_664', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2020-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_664', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2020-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_665', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2021-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_665', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2021-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_666', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2022-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_666', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2022-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_667', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2023-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_667', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2023-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_668', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2024-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_668', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2024-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_669', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2024-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_669', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2024-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_670', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2025-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_670', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2025-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_671', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2026-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_671', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2026-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_672', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2027-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_672', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2027-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_673', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2028-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_673', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2028-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_674', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2029-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_674', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2029-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_675', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2030-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_675', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2030-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_676', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2030-11-04', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_676', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2030-11-04', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_677', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2031-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_677', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2031-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_678', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2032-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_678', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2032-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_679', 'holiday_rrule_id' => 33, 'language_id' => 2, 'holiday' => '2033-11-03', 'title' => '文化の日', 'is_substitute' => false, ),
			array('key' => 'holiday_679', 'holiday_rrule_id' => 33, 'language_id' => 1, 'holiday' => '2033-11-03', 'title' => 'Culture Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_680', 'holiday_rrule_id' => 34, 'language_id' => 2, 'holiday' => '1970-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_680', 'holiday_rrule_id' => 34, 'language_id' => 1, 'holiday' => '1970-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_681', 'holiday_rrule_id' => 34, 'language_id' => 2, 'holiday' => '1971-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_681', 'holiday_rrule_id' => 34, 'language_id' => 1, 'holiday' => '1971-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_682', 'holiday_rrule_id' => 34, 'language_id' => 2, 'holiday' => '1972-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_682', 'holiday_rrule_id' => 34, 'language_id' => 1, 'holiday' => '1972-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_683', 'holiday_rrule_id' => 34, 'language_id' => 2, 'holiday' => '1973-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_683', 'holiday_rrule_id' => 34, 'language_id' => 1, 'holiday' => '1973-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_684', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1974-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_684', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1974-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_685', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1975-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_685', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1975-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_686', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1975-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_686', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1975-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_687', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1976-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_687', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1976-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_688', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1977-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_688', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1977-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_689', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1978-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_689', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1978-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_690', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1979-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_690', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1979-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_691', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1980-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_691', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1980-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_692', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1980-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_692', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1980-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_693', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1981-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_693', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1981-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_694', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1982-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_694', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1982-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_695', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1983-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_695', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1983-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_696', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1984-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_696', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1984-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_697', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1985-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_697', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1985-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_698', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1986-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_698', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1986-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_699', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1986-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_699', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1986-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_700', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1987-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_700', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1987-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_701', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1988-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_701', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1988-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_702', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1989-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_702', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1989-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_703', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1990-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_703', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1990-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_704', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1991-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_704', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1991-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_705', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1992-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_705', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1992-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_706', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1993-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_706', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1993-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_707', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1994-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_707', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1994-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_708', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1995-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_708', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1995-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_709', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1996-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_709', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1996-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_710', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1997-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_710', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1997-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_711', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1997-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_711', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1997-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_712', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1998-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_712', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1998-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_713', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '1999-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_713', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '1999-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_714', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2000-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_714', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2000-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_715', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2001-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_715', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2001-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_716', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2002-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_716', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2002-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_717', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2003-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_717', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2003-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_718', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2003-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_718', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2003-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_719', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2004-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_719', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2004-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_720', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2005-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_720', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2005-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_721', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2006-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_721', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2006-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_722', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2007-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_722', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2007-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_723', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2008-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_723', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2008-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_724', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2008-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_724', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2008-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_725', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2009-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_725', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2009-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_726', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2010-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_726', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2010-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_727', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2011-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_727', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2011-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_728', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2012-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_728', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2012-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_729', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2013-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_729', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2013-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_730', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2014-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_730', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2014-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_731', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2014-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_731', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2014-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_732', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2015-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_732', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2015-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_733', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2016-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_733', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2016-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_734', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2017-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_734', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2017-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_735', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2018-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_735', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2018-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_736', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2019-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_736', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2019-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_737', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2020-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_737', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2020-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_738', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2021-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_738', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2021-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_739', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2022-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_739', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2022-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_740', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2023-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_740', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2023-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_741', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2024-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_741', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2024-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_742', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2025-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_742', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2025-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_743', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2025-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_743', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2025-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_744', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2026-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_744', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2026-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_745', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2027-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_745', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2027-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_746', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2028-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_746', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2028-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_747', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2029-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_747', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2029-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_748', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2030-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_748', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2030-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_749', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2031-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_749', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2031-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_750', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2031-11-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_750', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2031-11-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_751', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2032-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_751', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2032-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_752', 'holiday_rrule_id' => 35, 'language_id' => 2, 'holiday' => '2033-11-23', 'title' => '勤労感謝の日', 'is_substitute' => false, ),
			array('key' => 'holiday_752', 'holiday_rrule_id' => 35, 'language_id' => 1, 'holiday' => '2033-11-23', 'title' => 'Labor Thanksgiving Day', 'is_substitute' => false, ),
			array('key' => 'holiday_753', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1989-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_753', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1989-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_754', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1990-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_754', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1990-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_755', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1990-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_755', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1990-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_756', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1991-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_756', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1991-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_757', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1992-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_757', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1992-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_758', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1993-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_758', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1993-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_759', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1994-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_759', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1994-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_760', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1995-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_760', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1995-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_761', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1996-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_761', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1996-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_762', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1997-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_762', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1997-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_763', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1998-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_763', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1998-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_764', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '1999-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_764', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '1999-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_765', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2000-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_765', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2000-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_766', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2001-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_766', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2001-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_767', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2001-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_767', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2001-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_768', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2002-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_768', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2002-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_769', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2003-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_769', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2003-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_770', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2004-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_770', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2004-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_771', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2005-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_771', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2005-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_772', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2006-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_772', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2006-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_773', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2007-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_773', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2007-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_774', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2007-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_774', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2007-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_775', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2008-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_775', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2008-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_776', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2009-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_776', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2009-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_777', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2010-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_777', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2010-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_778', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2011-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_778', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2011-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_779', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2012-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_779', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2012-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_780', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2012-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_780', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2012-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_781', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2013-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_781', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2013-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_782', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2014-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_782', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2014-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_783', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2015-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_783', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2015-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_784', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2016-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_784', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2016-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_785', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2017-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_785', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2017-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_786', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2018-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_786', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2018-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_787', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2018-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_787', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2018-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_788', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2019-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_788', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2019-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_789', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2020-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_789', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2020-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_790', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2021-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_790', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2021-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_791', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2022-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_791', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2022-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_792', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2023-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_792', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2023-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_793', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2024-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_793', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2024-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_794', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2025-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_794', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2025-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_795', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2026-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_795', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2026-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_796', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2027-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_796', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2027-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_797', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2028-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_797', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2028-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_798', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2029-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_798', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2029-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_799', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2029-12-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_799', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2029-12-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_800', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2030-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_800', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2030-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_801', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2031-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_801', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2031-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_802', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2032-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_802', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2032-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_803', 'holiday_rrule_id' => 36, 'language_id' => 2, 'holiday' => '2033-12-23', 'title' => '天皇誕生日', 'is_substitute' => false, ),
			array('key' => 'holiday_803', 'holiday_rrule_id' => 36, 'language_id' => 1, 'holiday' => '2033-12-23', 'title' => 'Emperor\'s Birthday Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_804', 'holiday_rrule_id' => 37, 'language_id' => 2, 'holiday' => '1975-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_804', 'holiday_rrule_id' => 37, 'language_id' => 1, 'holiday' => '1975-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_805', 'holiday_rrule_id' => 38, 'language_id' => 2, 'holiday' => '1976-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_805', 'holiday_rrule_id' => 38, 'language_id' => 1, 'holiday' => '1976-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_806', 'holiday_rrule_id' => 39, 'language_id' => 2, 'holiday' => '1977-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_806', 'holiday_rrule_id' => 39, 'language_id' => 1, 'holiday' => '1977-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_807', 'holiday_rrule_id' => 40, 'language_id' => 2, 'holiday' => '1978-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_807', 'holiday_rrule_id' => 40, 'language_id' => 1, 'holiday' => '1978-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_808', 'holiday_rrule_id' => 41, 'language_id' => 2, 'holiday' => '1979-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_808', 'holiday_rrule_id' => 41, 'language_id' => 1, 'holiday' => '1979-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_809', 'holiday_rrule_id' => 42, 'language_id' => 2, 'holiday' => '1980-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_809', 'holiday_rrule_id' => 42, 'language_id' => 1, 'holiday' => '1980-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_810', 'holiday_rrule_id' => 43, 'language_id' => 2, 'holiday' => '1981-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_810', 'holiday_rrule_id' => 43, 'language_id' => 1, 'holiday' => '1981-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_811', 'holiday_rrule_id' => 44, 'language_id' => 2, 'holiday' => '1982-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_811', 'holiday_rrule_id' => 44, 'language_id' => 1, 'holiday' => '1982-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_812', 'holiday_rrule_id' => 44, 'language_id' => 2, 'holiday' => '1982-03-22', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_812', 'holiday_rrule_id' => 44, 'language_id' => 1, 'holiday' => '1982-03-22', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_813', 'holiday_rrule_id' => 45, 'language_id' => 2, 'holiday' => '1983-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_813', 'holiday_rrule_id' => 45, 'language_id' => 1, 'holiday' => '1983-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_814', 'holiday_rrule_id' => 46, 'language_id' => 2, 'holiday' => '1984-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_814', 'holiday_rrule_id' => 46, 'language_id' => 1, 'holiday' => '1984-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_815', 'holiday_rrule_id' => 47, 'language_id' => 2, 'holiday' => '1985-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_815', 'holiday_rrule_id' => 47, 'language_id' => 1, 'holiday' => '1985-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_816', 'holiday_rrule_id' => 48, 'language_id' => 2, 'holiday' => '1986-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_816', 'holiday_rrule_id' => 48, 'language_id' => 1, 'holiday' => '1986-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_817', 'holiday_rrule_id' => 49, 'language_id' => 2, 'holiday' => '1987-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_817', 'holiday_rrule_id' => 49, 'language_id' => 1, 'holiday' => '1987-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_818', 'holiday_rrule_id' => 50, 'language_id' => 2, 'holiday' => '1988-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_818', 'holiday_rrule_id' => 50, 'language_id' => 1, 'holiday' => '1988-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_819', 'holiday_rrule_id' => 50, 'language_id' => 2, 'holiday' => '1988-03-21', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_819', 'holiday_rrule_id' => 50, 'language_id' => 1, 'holiday' => '1988-03-21', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_820', 'holiday_rrule_id' => 51, 'language_id' => 2, 'holiday' => '1989-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_820', 'holiday_rrule_id' => 51, 'language_id' => 1, 'holiday' => '1989-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_821', 'holiday_rrule_id' => 52, 'language_id' => 2, 'holiday' => '1990-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_821', 'holiday_rrule_id' => 52, 'language_id' => 1, 'holiday' => '1990-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_822', 'holiday_rrule_id' => 53, 'language_id' => 2, 'holiday' => '1991-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_822', 'holiday_rrule_id' => 53, 'language_id' => 1, 'holiday' => '1991-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_823', 'holiday_rrule_id' => 54, 'language_id' => 2, 'holiday' => '1992-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_823', 'holiday_rrule_id' => 54, 'language_id' => 1, 'holiday' => '1992-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_824', 'holiday_rrule_id' => 55, 'language_id' => 2, 'holiday' => '1993-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_824', 'holiday_rrule_id' => 55, 'language_id' => 1, 'holiday' => '1993-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_825', 'holiday_rrule_id' => 56, 'language_id' => 2, 'holiday' => '1994-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_825', 'holiday_rrule_id' => 56, 'language_id' => 1, 'holiday' => '1994-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_826', 'holiday_rrule_id' => 57, 'language_id' => 2, 'holiday' => '1995-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_826', 'holiday_rrule_id' => 57, 'language_id' => 1, 'holiday' => '1995-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_827', 'holiday_rrule_id' => 58, 'language_id' => 2, 'holiday' => '1996-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_827', 'holiday_rrule_id' => 58, 'language_id' => 1, 'holiday' => '1996-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_828', 'holiday_rrule_id' => 59, 'language_id' => 2, 'holiday' => '1997-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_828', 'holiday_rrule_id' => 59, 'language_id' => 1, 'holiday' => '1997-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_829', 'holiday_rrule_id' => 60, 'language_id' => 2, 'holiday' => '1998-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_829', 'holiday_rrule_id' => 60, 'language_id' => 1, 'holiday' => '1998-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_830', 'holiday_rrule_id' => 61, 'language_id' => 2, 'holiday' => '1999-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_830', 'holiday_rrule_id' => 61, 'language_id' => 1, 'holiday' => '1999-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_831', 'holiday_rrule_id' => 61, 'language_id' => 2, 'holiday' => '1999-03-22', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_831', 'holiday_rrule_id' => 61, 'language_id' => 1, 'holiday' => '1999-03-22', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_832', 'holiday_rrule_id' => 62, 'language_id' => 2, 'holiday' => '2000-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_832', 'holiday_rrule_id' => 62, 'language_id' => 1, 'holiday' => '2000-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_833', 'holiday_rrule_id' => 63, 'language_id' => 2, 'holiday' => '2001-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_833', 'holiday_rrule_id' => 63, 'language_id' => 1, 'holiday' => '2001-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_834', 'holiday_rrule_id' => 64, 'language_id' => 2, 'holiday' => '2002-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_834', 'holiday_rrule_id' => 64, 'language_id' => 1, 'holiday' => '2002-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_835', 'holiday_rrule_id' => 65, 'language_id' => 2, 'holiday' => '2003-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_835', 'holiday_rrule_id' => 65, 'language_id' => 1, 'holiday' => '2003-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_836', 'holiday_rrule_id' => 66, 'language_id' => 2, 'holiday' => '2004-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_836', 'holiday_rrule_id' => 66, 'language_id' => 1, 'holiday' => '2004-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_837', 'holiday_rrule_id' => 67, 'language_id' => 2, 'holiday' => '2005-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_837', 'holiday_rrule_id' => 67, 'language_id' => 1, 'holiday' => '2005-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_838', 'holiday_rrule_id' => 67, 'language_id' => 2, 'holiday' => '2005-03-21', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_838', 'holiday_rrule_id' => 67, 'language_id' => 1, 'holiday' => '2005-03-21', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_839', 'holiday_rrule_id' => 68, 'language_id' => 2, 'holiday' => '2006-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_839', 'holiday_rrule_id' => 68, 'language_id' => 1, 'holiday' => '2006-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_840', 'holiday_rrule_id' => 69, 'language_id' => 2, 'holiday' => '2007-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_840', 'holiday_rrule_id' => 69, 'language_id' => 1, 'holiday' => '2007-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_841', 'holiday_rrule_id' => 70, 'language_id' => 2, 'holiday' => '2008-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_841', 'holiday_rrule_id' => 70, 'language_id' => 1, 'holiday' => '2008-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_842', 'holiday_rrule_id' => 71, 'language_id' => 2, 'holiday' => '2009-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_842', 'holiday_rrule_id' => 71, 'language_id' => 1, 'holiday' => '2009-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_843', 'holiday_rrule_id' => 72, 'language_id' => 2, 'holiday' => '2010-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_843', 'holiday_rrule_id' => 72, 'language_id' => 1, 'holiday' => '2010-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_844', 'holiday_rrule_id' => 72, 'language_id' => 2, 'holiday' => '2010-03-22', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_844', 'holiday_rrule_id' => 72, 'language_id' => 1, 'holiday' => '2010-03-22', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_845', 'holiday_rrule_id' => 73, 'language_id' => 2, 'holiday' => '2011-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_845', 'holiday_rrule_id' => 73, 'language_id' => 1, 'holiday' => '2011-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_846', 'holiday_rrule_id' => 74, 'language_id' => 2, 'holiday' => '2012-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_846', 'holiday_rrule_id' => 74, 'language_id' => 1, 'holiday' => '2012-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_847', 'holiday_rrule_id' => 75, 'language_id' => 2, 'holiday' => '2013-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_847', 'holiday_rrule_id' => 75, 'language_id' => 1, 'holiday' => '2013-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_848', 'holiday_rrule_id' => 76, 'language_id' => 2, 'holiday' => '2014-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_848', 'holiday_rrule_id' => 76, 'language_id' => 1, 'holiday' => '2014-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_849', 'holiday_rrule_id' => 77, 'language_id' => 2, 'holiday' => '2015-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_849', 'holiday_rrule_id' => 77, 'language_id' => 1, 'holiday' => '2015-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_850', 'holiday_rrule_id' => 78, 'language_id' => 2, 'holiday' => '2016-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_850', 'holiday_rrule_id' => 78, 'language_id' => 1, 'holiday' => '2016-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_851', 'holiday_rrule_id' => 78, 'language_id' => 2, 'holiday' => '2016-03-21', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_851', 'holiday_rrule_id' => 78, 'language_id' => 1, 'holiday' => '2016-03-21', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_852', 'holiday_rrule_id' => 79, 'language_id' => 2, 'holiday' => '2017-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_852', 'holiday_rrule_id' => 79, 'language_id' => 1, 'holiday' => '2017-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_853', 'holiday_rrule_id' => 80, 'language_id' => 2, 'holiday' => '2018-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_853', 'holiday_rrule_id' => 80, 'language_id' => 1, 'holiday' => '2018-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_854', 'holiday_rrule_id' => 81, 'language_id' => 2, 'holiday' => '2019-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_854', 'holiday_rrule_id' => 81, 'language_id' => 1, 'holiday' => '2019-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_855', 'holiday_rrule_id' => 82, 'language_id' => 2, 'holiday' => '2020-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_855', 'holiday_rrule_id' => 82, 'language_id' => 1, 'holiday' => '2020-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_856', 'holiday_rrule_id' => 83, 'language_id' => 2, 'holiday' => '2021-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_856', 'holiday_rrule_id' => 83, 'language_id' => 1, 'holiday' => '2021-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_857', 'holiday_rrule_id' => 84, 'language_id' => 2, 'holiday' => '2022-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_857', 'holiday_rrule_id' => 84, 'language_id' => 1, 'holiday' => '2022-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_858', 'holiday_rrule_id' => 85, 'language_id' => 2, 'holiday' => '2023-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_858', 'holiday_rrule_id' => 85, 'language_id' => 1, 'holiday' => '2023-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_859', 'holiday_rrule_id' => 86, 'language_id' => 2, 'holiday' => '2024-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_859', 'holiday_rrule_id' => 86, 'language_id' => 1, 'holiday' => '2024-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_860', 'holiday_rrule_id' => 87, 'language_id' => 2, 'holiday' => '2025-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_860', 'holiday_rrule_id' => 87, 'language_id' => 1, 'holiday' => '2025-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_861', 'holiday_rrule_id' => 88, 'language_id' => 2, 'holiday' => '2026-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_861', 'holiday_rrule_id' => 88, 'language_id' => 1, 'holiday' => '2026-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_862', 'holiday_rrule_id' => 89, 'language_id' => 2, 'holiday' => '2027-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_862', 'holiday_rrule_id' => 89, 'language_id' => 1, 'holiday' => '2027-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_863', 'holiday_rrule_id' => 89, 'language_id' => 2, 'holiday' => '2027-03-22', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_863', 'holiday_rrule_id' => 89, 'language_id' => 1, 'holiday' => '2027-03-22', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_864', 'holiday_rrule_id' => 90, 'language_id' => 2, 'holiday' => '2028-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_864', 'holiday_rrule_id' => 90, 'language_id' => 1, 'holiday' => '2028-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_865', 'holiday_rrule_id' => 91, 'language_id' => 2, 'holiday' => '2029-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_865', 'holiday_rrule_id' => 91, 'language_id' => 1, 'holiday' => '2029-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_866', 'holiday_rrule_id' => 92, 'language_id' => 2, 'holiday' => '2030-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_866', 'holiday_rrule_id' => 92, 'language_id' => 1, 'holiday' => '2030-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_867', 'holiday_rrule_id' => 93, 'language_id' => 2, 'holiday' => '2031-03-21', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_867', 'holiday_rrule_id' => 93, 'language_id' => 1, 'holiday' => '2031-03-21', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_868', 'holiday_rrule_id' => 94, 'language_id' => 2, 'holiday' => '2032-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_868', 'holiday_rrule_id' => 94, 'language_id' => 1, 'holiday' => '2032-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_869', 'holiday_rrule_id' => 95, 'language_id' => 2, 'holiday' => '2033-03-20', 'title' => '春分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_869', 'holiday_rrule_id' => 95, 'language_id' => 1, 'holiday' => '2033-03-20', 'title' => 'Vernal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_870', 'holiday_rrule_id' => 95, 'language_id' => 2, 'holiday' => '2033-03-21', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_870', 'holiday_rrule_id' => 95, 'language_id' => 1, 'holiday' => '2033-03-21', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_871', 'holiday_rrule_id' => 96, 'language_id' => 2, 'holiday' => '1974-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_871', 'holiday_rrule_id' => 96, 'language_id' => 1, 'holiday' => '1974-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_872', 'holiday_rrule_id' => 97, 'language_id' => 2, 'holiday' => '1975-09-24', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_872', 'holiday_rrule_id' => 97, 'language_id' => 1, 'holiday' => '1975-09-24', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_873', 'holiday_rrule_id' => 98, 'language_id' => 2, 'holiday' => '1976-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_873', 'holiday_rrule_id' => 98, 'language_id' => 1, 'holiday' => '1976-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_874', 'holiday_rrule_id' => 99, 'language_id' => 2, 'holiday' => '1977-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_874', 'holiday_rrule_id' => 99, 'language_id' => 1, 'holiday' => '1977-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_875', 'holiday_rrule_id' => 100, 'language_id' => 2, 'holiday' => '1978-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_875', 'holiday_rrule_id' => 100, 'language_id' => 1, 'holiday' => '1978-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_876', 'holiday_rrule_id' => 101, 'language_id' => 2, 'holiday' => '1979-09-24', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_876', 'holiday_rrule_id' => 101, 'language_id' => 1, 'holiday' => '1979-09-24', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_877', 'holiday_rrule_id' => 102, 'language_id' => 2, 'holiday' => '1980-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_877', 'holiday_rrule_id' => 102, 'language_id' => 1, 'holiday' => '1980-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_878', 'holiday_rrule_id' => 103, 'language_id' => 2, 'holiday' => '1981-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_878', 'holiday_rrule_id' => 103, 'language_id' => 1, 'holiday' => '1981-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_879', 'holiday_rrule_id' => 104, 'language_id' => 2, 'holiday' => '1982-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_879', 'holiday_rrule_id' => 104, 'language_id' => 1, 'holiday' => '1982-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_880', 'holiday_rrule_id' => 105, 'language_id' => 2, 'holiday' => '1983-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_880', 'holiday_rrule_id' => 105, 'language_id' => 1, 'holiday' => '1983-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_881', 'holiday_rrule_id' => 106, 'language_id' => 2, 'holiday' => '1984-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_881', 'holiday_rrule_id' => 106, 'language_id' => 1, 'holiday' => '1984-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_882', 'holiday_rrule_id' => 106, 'language_id' => 2, 'holiday' => '1984-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_882', 'holiday_rrule_id' => 106, 'language_id' => 1, 'holiday' => '1984-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_883', 'holiday_rrule_id' => 107, 'language_id' => 2, 'holiday' => '1985-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_883', 'holiday_rrule_id' => 107, 'language_id' => 1, 'holiday' => '1985-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_884', 'holiday_rrule_id' => 108, 'language_id' => 2, 'holiday' => '1986-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_884', 'holiday_rrule_id' => 108, 'language_id' => 1, 'holiday' => '1986-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_885', 'holiday_rrule_id' => 109, 'language_id' => 2, 'holiday' => '1987-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_885', 'holiday_rrule_id' => 109, 'language_id' => 1, 'holiday' => '1987-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_886', 'holiday_rrule_id' => 110, 'language_id' => 2, 'holiday' => '1988-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_886', 'holiday_rrule_id' => 110, 'language_id' => 1, 'holiday' => '1988-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_887', 'holiday_rrule_id' => 111, 'language_id' => 2, 'holiday' => '1989-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_887', 'holiday_rrule_id' => 111, 'language_id' => 1, 'holiday' => '1989-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_888', 'holiday_rrule_id' => 112, 'language_id' => 2, 'holiday' => '1990-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_888', 'holiday_rrule_id' => 112, 'language_id' => 1, 'holiday' => '1990-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_889', 'holiday_rrule_id' => 112, 'language_id' => 2, 'holiday' => '1990-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_889', 'holiday_rrule_id' => 112, 'language_id' => 1, 'holiday' => '1990-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_890', 'holiday_rrule_id' => 113, 'language_id' => 2, 'holiday' => '1991-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_890', 'holiday_rrule_id' => 113, 'language_id' => 1, 'holiday' => '1991-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_891', 'holiday_rrule_id' => 114, 'language_id' => 2, 'holiday' => '1992-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_891', 'holiday_rrule_id' => 114, 'language_id' => 1, 'holiday' => '1992-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_892', 'holiday_rrule_id' => 115, 'language_id' => 2, 'holiday' => '1993-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_892', 'holiday_rrule_id' => 115, 'language_id' => 1, 'holiday' => '1993-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_893', 'holiday_rrule_id' => 116, 'language_id' => 2, 'holiday' => '1994-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_893', 'holiday_rrule_id' => 116, 'language_id' => 1, 'holiday' => '1994-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_894', 'holiday_rrule_id' => 117, 'language_id' => 2, 'holiday' => '1995-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_894', 'holiday_rrule_id' => 117, 'language_id' => 1, 'holiday' => '1995-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_895', 'holiday_rrule_id' => 118, 'language_id' => 2, 'holiday' => '1996-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_895', 'holiday_rrule_id' => 118, 'language_id' => 1, 'holiday' => '1996-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_896', 'holiday_rrule_id' => 119, 'language_id' => 2, 'holiday' => '1997-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_896', 'holiday_rrule_id' => 119, 'language_id' => 1, 'holiday' => '1997-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_897', 'holiday_rrule_id' => 120, 'language_id' => 2, 'holiday' => '1998-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_897', 'holiday_rrule_id' => 120, 'language_id' => 1, 'holiday' => '1998-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_898', 'holiday_rrule_id' => 121, 'language_id' => 2, 'holiday' => '1999-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_898', 'holiday_rrule_id' => 121, 'language_id' => 1, 'holiday' => '1999-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_899', 'holiday_rrule_id' => 122, 'language_id' => 2, 'holiday' => '2000-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_899', 'holiday_rrule_id' => 122, 'language_id' => 1, 'holiday' => '2000-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_900', 'holiday_rrule_id' => 123, 'language_id' => 2, 'holiday' => '2001-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_900', 'holiday_rrule_id' => 123, 'language_id' => 1, 'holiday' => '2001-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_901', 'holiday_rrule_id' => 123, 'language_id' => 2, 'holiday' => '2001-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_901', 'holiday_rrule_id' => 123, 'language_id' => 1, 'holiday' => '2001-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_902', 'holiday_rrule_id' => 124, 'language_id' => 2, 'holiday' => '2002-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_902', 'holiday_rrule_id' => 124, 'language_id' => 1, 'holiday' => '2002-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_903', 'holiday_rrule_id' => 125, 'language_id' => 2, 'holiday' => '2003-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_903', 'holiday_rrule_id' => 125, 'language_id' => 1, 'holiday' => '2003-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_904', 'holiday_rrule_id' => 126, 'language_id' => 2, 'holiday' => '2004-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_904', 'holiday_rrule_id' => 126, 'language_id' => 1, 'holiday' => '2004-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_905', 'holiday_rrule_id' => 127, 'language_id' => 2, 'holiday' => '2005-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_905', 'holiday_rrule_id' => 127, 'language_id' => 1, 'holiday' => '2005-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_906', 'holiday_rrule_id' => 128, 'language_id' => 2, 'holiday' => '2006-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_906', 'holiday_rrule_id' => 128, 'language_id' => 1, 'holiday' => '2006-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_907', 'holiday_rrule_id' => 129, 'language_id' => 2, 'holiday' => '2007-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_907', 'holiday_rrule_id' => 129, 'language_id' => 1, 'holiday' => '2007-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_908', 'holiday_rrule_id' => 129, 'language_id' => 2, 'holiday' => '2007-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_908', 'holiday_rrule_id' => 129, 'language_id' => 1, 'holiday' => '2007-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_909', 'holiday_rrule_id' => 130, 'language_id' => 2, 'holiday' => '2008-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_909', 'holiday_rrule_id' => 130, 'language_id' => 1, 'holiday' => '2008-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_910', 'holiday_rrule_id' => 131, 'language_id' => 2, 'holiday' => '2009-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_910', 'holiday_rrule_id' => 131, 'language_id' => 1, 'holiday' => '2009-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_911', 'holiday_rrule_id' => 132, 'language_id' => 2, 'holiday' => '2010-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_911', 'holiday_rrule_id' => 132, 'language_id' => 1, 'holiday' => '2010-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_912', 'holiday_rrule_id' => 133, 'language_id' => 2, 'holiday' => '2011-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_912', 'holiday_rrule_id' => 133, 'language_id' => 1, 'holiday' => '2011-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_913', 'holiday_rrule_id' => 134, 'language_id' => 2, 'holiday' => '2012-09-22', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_913', 'holiday_rrule_id' => 134, 'language_id' => 1, 'holiday' => '2012-09-22', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_914', 'holiday_rrule_id' => 135, 'language_id' => 2, 'holiday' => '2013-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_914', 'holiday_rrule_id' => 135, 'language_id' => 1, 'holiday' => '2013-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_915', 'holiday_rrule_id' => 136, 'language_id' => 2, 'holiday' => '2014-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_915', 'holiday_rrule_id' => 136, 'language_id' => 1, 'holiday' => '2014-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_916', 'holiday_rrule_id' => 137, 'language_id' => 2, 'holiday' => '2015-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_916', 'holiday_rrule_id' => 137, 'language_id' => 1, 'holiday' => '2015-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_917', 'holiday_rrule_id' => 138, 'language_id' => 2, 'holiday' => '2016-09-22', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_917', 'holiday_rrule_id' => 138, 'language_id' => 1, 'holiday' => '2016-09-22', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_918', 'holiday_rrule_id' => 139, 'language_id' => 2, 'holiday' => '2017-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_918', 'holiday_rrule_id' => 139, 'language_id' => 1, 'holiday' => '2017-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_919', 'holiday_rrule_id' => 140, 'language_id' => 2, 'holiday' => '2018-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_919', 'holiday_rrule_id' => 140, 'language_id' => 1, 'holiday' => '2018-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_920', 'holiday_rrule_id' => 140, 'language_id' => 2, 'holiday' => '2018-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_920', 'holiday_rrule_id' => 140, 'language_id' => 1, 'holiday' => '2018-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_921', 'holiday_rrule_id' => 141, 'language_id' => 2, 'holiday' => '2019-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_921', 'holiday_rrule_id' => 141, 'language_id' => 1, 'holiday' => '2019-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_922', 'holiday_rrule_id' => 142, 'language_id' => 2, 'holiday' => '2020-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_922', 'holiday_rrule_id' => 142, 'language_id' => 1, 'holiday' => '2020-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_923', 'holiday_rrule_id' => 143, 'language_id' => 2, 'holiday' => '2021-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_923', 'holiday_rrule_id' => 143, 'language_id' => 1, 'holiday' => '2021-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_924', 'holiday_rrule_id' => 144, 'language_id' => 2, 'holiday' => '2022-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_924', 'holiday_rrule_id' => 144, 'language_id' => 1, 'holiday' => '2022-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_925', 'holiday_rrule_id' => 145, 'language_id' => 2, 'holiday' => '2023-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_925', 'holiday_rrule_id' => 145, 'language_id' => 1, 'holiday' => '2023-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_926', 'holiday_rrule_id' => 146, 'language_id' => 2, 'holiday' => '2024-09-22', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_926', 'holiday_rrule_id' => 146, 'language_id' => 1, 'holiday' => '2024-09-22', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_927', 'holiday_rrule_id' => 147, 'language_id' => 2, 'holiday' => '2025-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_927', 'holiday_rrule_id' => 147, 'language_id' => 1, 'holiday' => '2025-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_928', 'holiday_rrule_id' => 148, 'language_id' => 2, 'holiday' => '2026-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_928', 'holiday_rrule_id' => 148, 'language_id' => 1, 'holiday' => '2026-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_929', 'holiday_rrule_id' => 149, 'language_id' => 2, 'holiday' => '2027-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_929', 'holiday_rrule_id' => 149, 'language_id' => 1, 'holiday' => '2027-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_930', 'holiday_rrule_id' => 150, 'language_id' => 2, 'holiday' => '2028-09-22', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_930', 'holiday_rrule_id' => 150, 'language_id' => 1, 'holiday' => '2028-09-22', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_931', 'holiday_rrule_id' => 151, 'language_id' => 2, 'holiday' => '2029-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_931', 'holiday_rrule_id' => 151, 'language_id' => 1, 'holiday' => '2029-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_932', 'holiday_rrule_id' => 151, 'language_id' => 2, 'holiday' => '2029-09-24', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_932', 'holiday_rrule_id' => 151, 'language_id' => 1, 'holiday' => '2029-09-24', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_933', 'holiday_rrule_id' => 152, 'language_id' => 2, 'holiday' => '2030-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_933', 'holiday_rrule_id' => 152, 'language_id' => 1, 'holiday' => '2030-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_934', 'holiday_rrule_id' => 153, 'language_id' => 2, 'holiday' => '2031-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_934', 'holiday_rrule_id' => 153, 'language_id' => 1, 'holiday' => '2031-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_935', 'holiday_rrule_id' => 154, 'language_id' => 2, 'holiday' => '2032-09-22', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_935', 'holiday_rrule_id' => 154, 'language_id' => 1, 'holiday' => '2032-09-22', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_936', 'holiday_rrule_id' => 155, 'language_id' => 2, 'holiday' => '2033-09-23', 'title' => '秋分の日', 'is_substitute' => false, ),
			array('key' => 'holiday_936', 'holiday_rrule_id' => 155, 'language_id' => 1, 'holiday' => '2033-09-23', 'title' => 'Autumnal Equinox Day', 'is_substitute' => false, ),
			array('key' => 'holiday_937', 'holiday_rrule_id' => 156, 'language_id' => 2, 'holiday' => '1988-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_937', 'holiday_rrule_id' => 156, 'language_id' => 1, 'holiday' => '1988-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_938', 'holiday_rrule_id' => 157, 'language_id' => 2, 'holiday' => '1989-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_938', 'holiday_rrule_id' => 157, 'language_id' => 1, 'holiday' => '1989-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_939', 'holiday_rrule_id' => 158, 'language_id' => 2, 'holiday' => '1990-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_939', 'holiday_rrule_id' => 158, 'language_id' => 1, 'holiday' => '1990-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_940', 'holiday_rrule_id' => 159, 'language_id' => 2, 'holiday' => '1991-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_940', 'holiday_rrule_id' => 159, 'language_id' => 1, 'holiday' => '1991-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_941', 'holiday_rrule_id' => 160, 'language_id' => 2, 'holiday' => '1993-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_941', 'holiday_rrule_id' => 160, 'language_id' => 1, 'holiday' => '1993-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_942', 'holiday_rrule_id' => 161, 'language_id' => 2, 'holiday' => '1994-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_942', 'holiday_rrule_id' => 161, 'language_id' => 1, 'holiday' => '1994-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_943', 'holiday_rrule_id' => 162, 'language_id' => 2, 'holiday' => '1995-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_943', 'holiday_rrule_id' => 162, 'language_id' => 1, 'holiday' => '1995-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_944', 'holiday_rrule_id' => 163, 'language_id' => 2, 'holiday' => '1996-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_944', 'holiday_rrule_id' => 163, 'language_id' => 1, 'holiday' => '1996-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_945', 'holiday_rrule_id' => 164, 'language_id' => 2, 'holiday' => '1999-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_945', 'holiday_rrule_id' => 164, 'language_id' => 1, 'holiday' => '1999-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_946', 'holiday_rrule_id' => 165, 'language_id' => 2, 'holiday' => '2000-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_946', 'holiday_rrule_id' => 165, 'language_id' => 1, 'holiday' => '2000-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_947', 'holiday_rrule_id' => 166, 'language_id' => 2, 'holiday' => '2001-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_947', 'holiday_rrule_id' => 166, 'language_id' => 1, 'holiday' => '2001-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_948', 'holiday_rrule_id' => 167, 'language_id' => 2, 'holiday' => '2002-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_948', 'holiday_rrule_id' => 167, 'language_id' => 1, 'holiday' => '2002-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_949', 'holiday_rrule_id' => 168, 'language_id' => 2, 'holiday' => '2004-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_949', 'holiday_rrule_id' => 168, 'language_id' => 1, 'holiday' => '2004-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_950', 'holiday_rrule_id' => 169, 'language_id' => 2, 'holiday' => '2005-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_950', 'holiday_rrule_id' => 169, 'language_id' => 1, 'holiday' => '2005-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_951', 'holiday_rrule_id' => 170, 'language_id' => 2, 'holiday' => '2006-05-04', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_951', 'holiday_rrule_id' => 170, 'language_id' => 1, 'holiday' => '2006-05-04', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_952', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '1996-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_952', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '1996-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_953', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '1997-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_953', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '1997-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_954', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '1997-07-21', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_954', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '1997-07-21', 'title' => 'Transfer holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_955', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '1998-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_955', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '1998-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_956', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '1999-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_956', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '1999-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_957', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '2000-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_957', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '2000-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_958', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '2001-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_958', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '2001-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_959', 'holiday_rrule_id' => 171, 'language_id' => 2, 'holiday' => '2002-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_959', 'holiday_rrule_id' => 171, 'language_id' => 1, 'holiday' => '2002-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_960', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2003-07-21', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_960', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2003-07-21', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_961', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2004-07-19', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_961', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2004-07-19', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_962', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2005-07-18', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_962', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2005-07-18', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_963', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2006-07-17', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_963', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2006-07-17', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_964', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2007-07-16', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_964', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2007-07-16', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_965', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2008-07-21', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_965', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2008-07-21', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_966', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2009-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_966', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2009-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_967', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2010-07-19', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_967', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2010-07-19', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_968', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2011-07-18', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_968', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2011-07-18', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_969', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2012-07-16', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_969', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2012-07-16', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_970', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2013-07-15', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_970', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2013-07-15', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_971', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2014-07-21', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_971', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2014-07-21', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_972', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2015-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_972', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2015-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_973', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2016-07-18', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_973', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2016-07-18', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_974', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2017-07-17', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_974', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2017-07-17', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_975', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2018-07-16', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_975', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2018-07-16', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_976', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2019-07-15', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_976', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2019-07-15', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_977', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2020-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_977', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2020-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_978', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2021-07-19', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_978', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2021-07-19', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_979', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2022-07-18', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_979', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2022-07-18', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_980', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2023-07-17', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_980', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2023-07-17', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_981', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2024-07-15', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_981', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2024-07-15', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_982', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2025-07-21', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_982', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2025-07-21', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_983', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2026-07-20', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_983', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2026-07-20', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_984', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2027-07-19', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_984', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2027-07-19', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_985', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2028-07-17', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_985', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2028-07-17', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_986', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2029-07-16', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_986', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2029-07-16', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_987', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2030-07-15', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_987', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2030-07-15', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_988', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2031-07-21', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_988', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2031-07-21', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_989', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2032-07-19', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_989', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2032-07-19', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_990', 'holiday_rrule_id' => 172, 'language_id' => 2, 'holiday' => '2033-07-18', 'title' => '海の日', 'is_substitute' => false, ),
			array('key' => 'holiday_990', 'holiday_rrule_id' => 172, 'language_id' => 1, 'holiday' => '2033-07-18', 'title' => 'Marine Day', 'is_substitute' => false, ),
			array('key' => 'holiday_991', 'holiday_rrule_id' => 173, 'language_id' => 2, 'holiday' => '2015-09-22', 'title' => '国民の休日', 'is_substitute' => false, ),
			array('key' => 'holiday_991', 'holiday_rrule_id' => 173, 'language_id' => 1, 'holiday' => '2015-09-22', 'title' => 'National People\'s Day Holiday', 'is_substitute' => false, ),
			array('key' => 'holiday_992', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2016-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_992', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2016-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_993', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2017-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_993', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2017-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_994', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2019-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_994', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2019-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_994', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2019-08-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_994', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2019-08-11', 'title' => 'substitute holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_995', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2020-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_995', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2020-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_996', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2021-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_996', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2021-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_997', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2022-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_997', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2022-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_998', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2023-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_998', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2023-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_999', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2024-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_999', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2024-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_999', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2024-08-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_999', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2024-08-11', 'title' => 'substitute holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_1000', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2025-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1000', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2025-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1001', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2026-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1001', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2026-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1002', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2027-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1002', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2027-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1003', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2028-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1003', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2028-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1004', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2029-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1004', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2029-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1005', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2030-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1005', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2030-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1005', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2030-08-12', 'title' => '(振替休日)', 'is_substitute' => true, ),
			array('key' => 'holiday_1005', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2030-08-11', 'title' => 'substitute holiday', 'is_substitute' => true, ),
			array('key' => 'holiday_1006', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2031-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1006', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2031-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1007', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2032-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1007', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2032-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
			array('key' => 'holiday_1008', 'holiday_rrule_id' => 174, 'language_id' => 2, 'holiday' => '2033-08-11', 'title' => '山の日', 'is_substitute' => false, ),
			array('key' => 'holiday_1008', 'holiday_rrule_id' => 174, 'language_id' => 1, 'holiday' => '2033-08-11', 'title' => 'Mountain Day', 'is_substitute' => false, ),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		foreach ($this->records as $model => $records) {
			if ($direction === 'up') {
				if (!$this->updateRecords($model, $records)) {
					return false;
				}
			} elseif ($direction === 'down') {
				if ($model == 'Holiday') {
					if (!$this->deleteRecords($model, $records, 'key')) {
						return false;
					}
				} else {
					if (!$this->deleteRecords($model, $records)) {
						return false;
					}
				}
			}
		}
		return true;
	}
}
