/**
 * @fileoverview UserManager Javascript
 * @author nakajimashouhei@gmail.com (Shohei Nakajima)
 */


/**
 * UserManager controller
 */
NetCommonsApp.controller('UserManagerController',
    ['$scope', 'NetCommonsModal', 'NC3_URL', function($scope, NetCommonsModal, NC3_URL) {

      /**
       * 検索ダイアログ表示
       *
       * @param {array} condtions 条件配列
       * @param {string} callbackUrl callbackするURL
       * @return {void}
       */
      $scope.showUserSearch = function(condtions, callbackUrl) {
        console.log(callbackUrl);
        NetCommonsModal.show(
            $scope, 'UserManagerSearch',
            NC3_URL + '/user_manager/user_manager/search/conditions',
            {
              backdrop: 'static',
              size: 'lg',
              resolve: {
                options: {
                  condtions: condtions,
                  callbackUrl: callbackUrl
                }
              }
            }
        );
      };

      /**
       * Show user information method
       *
       * @param {number} users.id
       * @return {void}
       */
      $scope.showUser = function(id) {
        NetCommonsModal.show(
            $scope, 'UserManagerView',
            NC3_URL + '/user_manager/user_manager/view/' + id + ''
        );
      };
    }]);


/**
 * UserManager search condtion modal controller
 */
NetCommonsApp.controller('UserManagerSearch',
    ['$scope', '$http', '$uibModalInstance', '$window', 'options', 'NC3_URL',
      function($scope, $http, $uibModalInstance, $window, options, NC3_URL) {

        /**
         * 検索条件を保持する変数
         */
        $scope.condtions = options['condtions'];

        /**
         * 初期処理
         *
         * @return {void}
         */
        $scope.initialize = function(domId) {
          $scope.domId = domId;
        };

        /**
         * 検索処理
         *
         * @return {void}
         */
        $scope.search = function() {
          var element = angular.element('#' + $scope.domId);
          $scope.condtions = {};
          angular.forEach(element.serializeArray(), function(input) {
            if (input['value'] !== '') {
              this.condtions[input['name']] = input['value'];
            }
          }, $scope);

          $http.post(NC3_URL + '/user_manager/user_manager/search/result',
              $.param({_method: 'POST', data: $scope.condtions}),
              {cache: false,
                headers:
                    {'Content-Type': 'application/x-www-form-urlencoded'}
              }
          )
          .success(function(data) {
                //success condition
                $window.location.href = NC3_URL + options['callbackUrl'] + '?search';
                //$uibModalInstance.close('success');
          })
          .error(function(data, status) {
                //error condition
                $uibModalInstance.dismiss('error');
          });
        };

        /**
         * キャンセル処理
         *
         * @return {void}
         */
        $scope.cancel = function() {
          $uibModalInstance.dismiss('cancel');
        };
      }]);


/**
 * User modal controller
 */
NetCommonsApp.controller('UserManagerView',
    ['$scope', '$uibModalInstance', function($scope, $uibModalInstance) {

      /**
       * dialog cancel
       *
       * @return {void}
       */
      $scope.cancel = function() {
        $uibModalInstance.dismiss('cancel');
      };
    }]);
