/*************************************************************
 *
 *  MathJax/fonts/HTML-CSS/TeX/png/Main/Italic/Main.js
 *  
 *  Defines the image size data needed for the HTML-CSS OutputJax
 *  to display mathematics using fallback images when the fonts
 *  are not available to the client browser.
 *
 *  ---------------------------------------------------------------------
 *
 *  Copyright (c) 2009-2013 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

MathJax.OutputJax["HTML-CSS"].defineImageData({
  "MathJax_Main-italic": {
    0x20: [  // SPACE
      [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
      [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
    ],
    0x21: [  // EXCLAMATION MARK
      [3,5,0],[4,6,0],[4,6,0],[5,8,0],[6,9,0],[7,11,0],[8,14,0],[9,15,0],
      [11,20,0],[13,24,0],[15,28,0],[18,34,0],[22,41,0],[25,47,0]
    ],
    0x22: [  // QUOTATION MARK
      [4,3,-2],[5,3,-3],[6,3,-3],[7,4,-4],[8,5,-4],[9,5,-6],[11,7,-7],[13,8,-8],
      [15,9,-10],[18,11,-12],[22,13,-14],[25,15,-18],[30,18,-21],[36,21,-24]
    ],
    0x23: [  // NUMBER SIGN
      [6,6,1],[7,8,2],[9,8,2],[10,10,2],[12,12,3],[14,14,3],[17,18,4],[20,20,4],
      [23,24,5],[28,29,6],[33,34,7],[39,42,9],[46,50,11],[55,58,13]
    ],
    0x25: [  // PERCENT SIGN
      [6,6,1],[8,8,1],[9,8,1],[10,10,1],[12,11,1],[15,13,1],[17,17,1],[20,18,1],
      [24,23,2],[28,29,3],[34,33,3],[40,38,3],[47,46,3],[56,53,4]
    ],
    0x26: [  // AMPERSAND
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,17,1],
      [23,21,1],[27,25,1],[32,29,0],[38,35,1],[45,43,2],[53,49,2]
    ],
    0x27: [  // APOSTROPHE
      [3,3,-2],[4,3,-3],[4,3,-3],[5,4,-4],[6,5,-4],[7,5,-6],[8,7,-7],[9,8,-8],
      [11,9,-10],[13,11,-12],[15,13,-14],[18,15,-18],[21,18,-21],[25,21,-24]
    ],
    0x28: [  // LEFT PARENTHESIS
      [4,8,3],[5,10,3],[6,10,3],[7,13,4],[8,15,4],[9,17,5],[11,22,6],[12,24,7],
      [15,28,8],[18,35,9],[21,40,11],[25,49,13],[29,58,15],[35,67,17]
    ],
    0x29: [  // RIGHT PARENTHESIS
      [3,7,2],[4,9,2],[4,9,2],[5,12,3],[6,14,3],[7,16,4],[8,21,5],[10,23,6],
      [11,27,7],[13,34,8],[16,39,10],[19,48,12],[22,57,14],[26,66,16]
    ],
    0x2A: [  // ASTERISK
      [5,3,-2],[5,5,-2],[6,5,-2],[7,6,-3],[9,6,-4],[10,8,-4],[12,9,-6],[14,10,-7],
      [17,12,-9],[20,15,-11],[23,17,-12],[28,21,-15],[33,25,-18],[39,28,-21]
    ],
    0x2B: [  // PLUS SIGN
      [6,5,1],[7,7,1],[8,7,1],[9,7,1],[11,9,1],[13,11,2],[15,13,1],[18,15,2],
      [21,18,3],[25,21,2],[30,24,2],[35,30,3],[42,35,3],[50,41,4]
    ],
    0x2C: [  // COMMA
      [2,2,1],[2,3,2],[3,3,2],[3,4,2],[4,5,3],[4,5,3],[5,7,4],[6,7,4],
      [7,9,5],[8,10,6],[10,12,7],[11,15,9],[13,18,11],[16,21,13]
    ],
    0x2D: [  // HYPHEN-MINUS
      [3,1,-1],[3,1,-1],[4,1,-1],[4,1,-2],[5,1,-2],[6,2,-2],[7,3,-3],[8,3,-3],
      [10,2,-5],[12,3,-6],[14,3,-7],[16,4,-9],[19,5,-10],[23,5,-12]
    ],
    0x2E: [  // FULL STOP
      [2,1,0],[2,2,0],[3,2,0],[3,2,0],[4,2,0],[4,2,0],[5,3,0],[6,3,0],
      [7,4,0],[8,5,0],[10,5,0],[11,6,0],[13,7,0],[16,8,0]
    ],
    0x2F: [  // SOLIDUS
      [5,7,2],[6,9,2],[7,9,2],[8,12,3],[9,14,3],[11,16,4],[12,21,5],[15,23,6],
      [18,27,7],[21,34,8],[25,39,10],[29,48,12],[35,57,14],[41,66,16]
    ],
    0x30: [  // DIGIT ZERO
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[14,16,1],
      [16,19,1],[19,24,1],[22,27,0],[27,33,1],[32,39,1],[37,45,1]
    ],
    0x31: [  // DIGIT ONE
      [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[10,14,0],[11,15,0],
      [13,19,0],[16,23,0],[19,26,0],[22,32,0],[26,38,0],[31,44,0]
    ],
    0x32: [  // DIGIT TWO
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
      [16,20,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
    ],
    0x33: [  // DIGIT THREE
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[14,15,0],
      [16,19,0],[19,23,0],[22,26,0],[27,33,1],[32,39,1],[37,45,1]
    ],
    0x34: [  // DIGIT FOUR
      [4,6,1],[4,8,2],[5,8,2],[6,10,2],[7,12,3],[8,14,3],[10,18,4],[12,19,4],
      [14,24,5],[16,29,6],[19,33,7],[23,41,9],[27,49,11],[32,57,13]
    ],
    0x35: [  // DIGIT FIVE
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,10,0],[10,11,0],[12,14,0],[14,16,1],
      [16,20,1],[19,23,1],[23,27,0],[27,33,1],[32,39,1],[38,45,1]
    ],
    0x36: [  // DIGIT SIX
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[12,14,0],[14,16,1],
      [16,19,1],[19,24,1],[23,28,1],[27,33,1],[32,39,1],[38,45,2]
    ],
    0x37: [  // DIGIT SEVEN
      [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,1],
      [18,20,1],[21,24,1],[25,27,0],[30,33,1],[36,40,2],[42,46,2]
    ],
    0x38: [  // DIGIT EIGHT
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
      [16,20,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
    ],
    0x39: [  // DIGIT NINE
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
      [16,19,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
    ],
    0x3A: [  // COLON
      [3,3,0],[3,4,0],[4,4,0],[4,5,0],[5,6,0],[6,7,0],[6,9,0],[8,10,0],
      [9,12,0],[11,15,0],[13,17,0],[15,21,0],[18,24,0],[21,28,0]
    ],
    0x3B: [  // SEMICOLON
      [3,4,1],[3,6,2],[4,6,2],[4,7,2],[5,9,3],[6,10,3],[6,13,4],[8,14,4],
      [9,17,5],[11,21,6],[13,24,7],[15,30,9],[18,35,11],[21,41,13]
    ],
    0x3D: [  // EQUALS SIGN
      [6,2,-1],[7,3,-1],[8,3,-1],[10,3,-1],[11,4,-2],[13,4,-2],[16,5,-3],[19,5,-3],
      [22,7,-3],[26,10,-4],[31,9,-5],[37,11,-6],[43,14,-8],[52,16,-9]
    ],
    0x3F: [  // QUESTION MARK
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,15,0],
      [16,20,0],[19,24,0],[22,28,0],[26,34,0],[31,41,0],[37,47,0]
    ],
    0x40: [  // COMMERCIAL AT
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,15,0],
      [22,20,0],[26,24,0],[31,27,0],[37,34,1],[44,41,1],[52,47,1]
    ],
    0x41: [  // LATIN CAPITAL LETTER A
      [5,5,0],[6,7,0],[7,7,0],[9,8,0],[10,10,0],[12,12,0],[14,15,0],[17,16,0],
      [20,20,0],[23,24,0],[28,28,0],[33,34,0],[39,41,0],[46,47,0]
    ],
    0x42: [  // LATIN CAPITAL LETTER B
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
      [21,19,0],[25,23,0],[29,26,0],[34,33,0],[41,39,0],[49,45,0]
    ],
    0x43: [  // LATIN CAPITAL LETTER C
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,1],
      [23,21,1],[27,25,1],[32,27,0],[38,35,1],[45,41,1],[54,48,1]
    ],
    0x44: [  // LATIN CAPITAL LETTER D
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],[16,14,0],[18,15,0],
      [22,19,0],[26,23,0],[31,26,0],[36,33,0],[43,39,0],[51,45,0]
    ],
    0x45: [  // LATIN CAPITAL LETTER E
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
      [21,19,0],[25,23,0],[30,26,0],[35,33,0],[42,39,0],[50,46,1]
    ],
    0x46: [  // LATIN CAPITAL LETTER F
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
      [21,19,0],[24,23,0],[29,26,0],[34,33,0],[41,38,0],[48,45,0]
    ],
    0x47: [  // LATIN CAPITAL LETTER G
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,1],
      [23,21,1],[27,25,1],[32,27,0],[38,35,1],[45,41,1],[54,48,1]
    ],
    0x48: [  // LATIN CAPITAL LETTER H
      [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,15,0],
      [24,19,0],[29,23,0],[34,26,0],[40,33,0],[48,39,0],[57,45,0]
    ],
    0x49: [  // LATIN CAPITAL LETTER I
      [4,5,0],[5,6,0],[5,6,0],[6,8,0],[8,9,0],[9,11,0],[10,14,0],[12,15,0],
      [15,19,0],[17,23,0],[20,26,0],[24,33,0],[29,39,0],[34,45,0]
    ],
    0x4A: [  // LATIN CAPITAL LETTER J
      [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,1],
      [18,20,1],[21,24,1],[25,26,0],[29,34,1],[35,40,1],[41,46,1]
    ],
    0x4B: [  // LATIN CAPITAL LETTER K
      [6,5,0],[8,7,1],[9,7,1],[11,9,1],[12,10,1],[15,12,1],[17,15,1],[20,16,1],
      [24,20,1],[29,24,1],[34,27,1],[40,33,0],[48,39,0],[57,46,1]
    ],
    0x4C: [  // LATIN CAPITAL LETTER L
      [5,6,1],[6,7,1],[7,7,1],[8,9,1],[9,10,1],[11,12,1],[13,15,1],[15,16,1],
      [18,20,1],[21,24,1],[25,27,1],[30,33,1],[35,40,1],[42,46,1]
    ],
    0x4D: [  // LATIN CAPITAL LETTER M
      [7,5,0],[9,6,0],[10,6,0],[12,8,0],[14,9,0],[17,11,0],[20,14,0],[24,15,0],
      [28,19,0],[34,23,0],[40,26,0],[47,33,0],[56,39,0],[67,46,1]
    ],
    0x4E: [  // LATIN CAPITAL LETTER N
      [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,10,0],[15,11,0],[17,14,0],[20,16,0],
      [24,19,0],[29,24,0],[34,27,0],[40,34,0],[48,40,0],[57,45,0]
    ],
    0x4F: [  // LATIN CAPITAL LETTER O
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,1],
      [22,21,1],[26,25,1],[31,27,0],[37,35,1],[44,41,1],[52,48,1]
    ],
    0x50: [  // LATIN CAPITAL LETTER P
      [6,5,0],[7,7,1],[8,7,1],[9,9,1],[11,10,1],[13,12,1],[15,15,1],[17,16,1],
      [21,20,1],[24,24,1],[29,27,1],[34,34,1],[41,40,1],[48,46,1]
    ],
    0x51: [  // LATIN CAPITAL LETTER Q
      [6,6,1],[7,8,2],[8,8,2],[10,10,2],[11,12,3],[14,14,3],[16,18,4],[19,19,4],
      [22,25,5],[26,30,6],[31,34,7],[37,43,9],[44,51,11],[52,59,13]
    ],
    0x52: [  // LATIN CAPITAL LETTER R
      [5,6,0],[6,7,0],[8,7,0],[9,9,0],[10,10,0],[12,12,0],[15,15,0],[17,17,1],
      [20,21,1],[24,25,1],[29,27,0],[34,35,1],[40,41,1],[48,47,1]
    ],
    0x53: [  // LATIN CAPITAL LETTER S
      [5,5,0],[6,7,0],[7,7,0],[8,8,0],[9,10,0],[11,12,0],[13,15,0],[15,17,1],
      [18,21,1],[21,25,1],[25,28,0],[30,35,1],[35,41,1],[42,48,1]
    ],
    0x54: [  // LATIN CAPITAL LETTER T
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,15,0],
      [23,19,0],[27,23,0],[32,26,0],[38,32,0],[45,38,0],[54,45,0]
    ],
    0x55: [  // LATIN CAPITAL LETTER U
      [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,16,1],
      [24,20,1],[29,24,1],[34,26,0],[40,34,1],[48,40,1],[57,47,2]
    ],
    0x56: [  // LATIN CAPITAL LETTER V
      [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[21,17,1],
      [24,20,1],[29,24,1],[34,27,0],[41,34,1],[48,40,1],[58,47,2]
    ],
    0x57: [  // LATIN CAPITAL LETTER W
      [8,5,0],[10,6,0],[12,6,0],[14,8,0],[16,9,0],[19,11,0],[22,14,0],[27,17,1],
      [32,20,1],[37,24,1],[44,27,0],[53,34,1],[63,41,2],[74,47,2]
    ],
    0x58: [  // LATIN CAPITAL LETTER X
      [6,5,0],[7,7,1],[9,7,1],[10,9,1],[12,10,1],[14,12,1],[16,15,1],[20,16,1],
      [23,20,1],[28,24,1],[33,27,1],[39,34,1],[46,39,0],[55,45,0]
    ],
    0x59: [  // LATIN CAPITAL LETTER Y
      [7,5,0],[8,6,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],[18,14,0],[21,15,0],
      [25,19,0],[29,23,0],[35,26,0],[41,33,0],[49,39,0],[58,45,0]
    ],
    0x5A: [  // LATIN CAPITAL LETTER Z
      [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
      [20,19,0],[24,23,0],[28,26,0],[33,33,0],[39,39,0],[47,45,0]
    ],
    0x5B: [  // LEFT SQUARE BRACKET
      [4,8,2],[4,10,3],[5,10,3],[6,12,3],[7,14,4],[8,16,4],[9,21,5],[11,23,6],
      [13,28,8],[15,36,9],[18,39,10],[21,47,12],[25,57,14],[30,66,16]
    ],
    0x5D: [  // RIGHT SQUARE BRACKET
      [4,8,2],[4,10,3],[5,10,3],[6,12,3],[6,14,4],[7,16,4],[8,21,5],[10,23,6],
      [11,28,8],[13,36,9],[15,39,10],[18,48,12],[21,57,14],[25,66,16]
    ],
    0x5E: [  // CIRCUMFLEX ACCENT
      [4,1,-4],[5,2,-4],[6,2,-4],[7,2,-6],[8,2,-7],[9,3,-8],[11,4,-10],[13,4,-12],
      [15,5,-14],[18,6,-17],[21,7,-20],[25,8,-25],[30,10,-29],[35,11,-34]
    ],
    0x5F: [  // LOW LINE
      [4,2,1],[5,2,1],[6,2,1],[7,2,1],[8,2,1],[10,2,1],[11,2,1],[14,2,1],
      [16,3,2],[19,4,3],[22,4,3],[27,5,4],[32,5,4],[37,6,5]
    ],
    0x61: [  // LATIN SMALL LETTER A
      [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[11,9,0],[13,10,0],
      [16,12,0],[18,15,0],[22,17,0],[26,22,1],[31,26,1],[36,30,1]
    ],
    0x62: [  // LATIN SMALL LETTER B
      [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[10,14,0],[11,16,0],
      [13,19,0],[16,23,0],[19,27,0],[22,34,1],[26,40,1],[31,46,1]
    ],
    0x63: [  // LATIN SMALL LETTER C
      [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
      [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
    ],
    0x64: [  // LATIN SMALL LETTER D
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[12,14,0],[14,15,0],
      [16,19,0],[19,23,0],[23,26,0],[27,34,1],[32,40,1],[38,46,1]
    ],
    0x65: [  // LATIN SMALL LETTER E
      [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
      [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
    ],
    0x66: [  // LATIN SMALL LETTER F
      [5,6,1],[5,8,2],[6,8,2],[7,10,2],[8,12,3],[9,14,3],[10,18,4],[12,19,4],
      [14,25,5],[16,30,6],[19,35,8],[23,44,10],[27,52,12],[32,60,13]
    ],
    0x67: [  // LATIN SMALL LETTER G
      [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,14,4],
      [14,17,5],[17,21,6],[20,25,8],[23,31,10],[28,37,12],[33,43,14]
    ],
    0x68: [  // LATIN SMALL LETTER H
      [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,0],
      [16,19,0],[18,23,0],[22,27,0],[26,34,1],[31,40,1],[36,46,1]
    ],
    0x69: [  // LATIN SMALL LETTER I
      [3,5,0],[3,6,0],[4,6,0],[4,8,0],[5,10,0],[6,11,0],[7,14,0],[8,15,0],
      [10,18,0],[12,23,0],[14,26,0],[16,32,1],[19,38,1],[23,44,1]
    ],
    0x6A: [  // LATIN SMALL LETTER J
      [4,6,1],[5,8,2],[5,8,2],[6,10,2],[7,13,3],[8,14,3],[9,18,4],[10,20,4],
      [12,24,5],[14,30,6],[17,34,8],[19,42,10],[23,49,12],[27,57,14]
    ],
    0x6B: [  // LATIN SMALL LETTER K
      [4,5,0],[5,6,0],[5,6,0],[6,8,0],[7,9,0],[9,11,0],[10,14,0],[12,16,0],
      [14,19,0],[17,23,0],[20,27,0],[24,34,1],[28,40,1],[33,46,1]
    ],
    0x6C: [  // LATIN SMALL LETTER L
      [3,5,0],[3,6,0],[4,6,0],[4,8,0],[5,9,0],[6,11,0],[7,14,0],[8,16,0],
      [9,19,0],[11,23,0],[13,27,0],[15,34,1],[18,40,1],[21,46,1]
    ],
    0x6D: [  // LATIN SMALL LETTER M
      [6,3,0],[8,4,0],[9,4,0],[10,5,0],[12,6,0],[15,7,0],[17,9,0],[20,10,0],
      [24,12,0],[28,15,0],[34,17,0],[40,22,1],[48,26,1],[56,30,1]
    ],
    0x6E: [  // LATIN SMALL LETTER N
      [5,3,0],[5,4,0],[6,4,0],[7,5,0],[9,6,0],[10,7,0],[12,9,0],[14,10,0],
      [17,12,0],[20,15,0],[24,17,0],[28,22,1],[33,26,1],[39,30,1]
    ],
    0x6F: [  // LATIN SMALL LETTER O
      [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[11,9,0],[12,10,0],
      [15,12,0],[18,15,0],[21,17,0],[25,22,1],[29,26,1],[35,30,1]
    ],
    0x70: [  // LATIN SMALL LETTER P
      [4,4,1],[5,6,2],[5,6,2],[6,7,2],[8,9,3],[9,10,3],[10,13,4],[12,14,4],
      [15,17,5],[17,21,6],[20,24,7],[24,30,9],[29,36,11],[34,43,14]
    ],
    0x71: [  // LATIN SMALL LETTER Q
      [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,14,4],
      [14,17,5],[17,21,6],[20,24,7],[24,30,9],[28,36,11],[34,42,13]
    ],
    0x72: [  // LATIN SMALL LETTER R
      [4,3,0],[5,4,0],[5,4,0],[6,5,0],[7,6,0],[9,7,0],[10,9,0],[12,10,0],
      [14,12,0],[16,15,0],[19,17,0],[23,22,1],[27,26,1],[32,30,1]
    ],
    0x73: [  // LATIN SMALL LETTER S
      [3,3,0],[4,4,0],[5,4,0],[5,5,0],[6,6,0],[7,7,0],[9,9,0],[10,11,1],
      [12,13,1],[14,16,1],[17,17,0],[20,22,1],[24,26,1],[28,30,1]
    ],
    0x74: [  // LATIN SMALL LETTER T
      [3,5,0],[4,6,0],[4,6,0],[5,7,0],[6,9,0],[7,10,0],[8,13,0],[9,15,0],
      [11,17,0],[13,22,0],[15,25,0],[18,30,1],[21,36,1],[25,42,1]
    ],
    0x75: [  // LATIN SMALL LETTER U
      [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[12,9,0],[14,10,0],
      [16,12,0],[19,15,0],[23,17,0],[27,22,1],[32,26,1],[38,30,1]
    ],
    0x76: [  // LATIN SMALL LETTER V
      [4,3,0],[5,4,0],[5,4,0],[6,5,0],[7,6,0],[9,7,0],[10,9,0],[12,10,0],
      [14,12,0],[17,15,0],[20,17,0],[23,22,1],[28,26,1],[33,30,1]
    ],
    0x77: [  // LATIN SMALL LETTER W
      [5,3,0],[6,4,0],[7,4,0],[9,5,0],[10,6,0],[12,7,0],[14,9,0],[17,10,0],
      [20,12,0],[23,15,0],[28,17,0],[33,22,1],[39,26,1],[46,30,1]
    ],
    0x78: [  // LATIN SMALL LETTER X
      [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[10,9,0],[12,10,0],
      [15,12,0],[17,15,0],[21,17,0],[24,22,1],[29,26,1],[34,30,1]
    ],
    0x79: [  // LATIN SMALL LETTER Y
      [4,4,1],[5,6,2],[6,6,2],[7,7,2],[8,9,3],[9,10,3],[11,13,4],[13,14,4],
      [15,17,5],[18,21,6],[21,25,8],[25,31,10],[29,37,12],[35,43,14]
    ],
    0x7A: [  // LATIN SMALL LETTER Z
      [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
      [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
    ],
    0x7E: [  // TILDE
      [4,1,-1],[5,1,-2],[6,1,-2],[7,2,-2],[8,2,-3],[10,2,-3],[12,3,-3],[14,4,-4],
      [16,3,-6],[19,4,-7],[23,5,-8],[27,5,-10],[32,7,-12],[38,7,-14]
    ],
    0xA3: [  // POUND SIGN
      [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
      [20,20,0],[24,24,0],[28,27,0],[33,34,1],[39,41,1],[47,48,1]
    ],
    0x131: [  // LATIN SMALL LETTER DOTLESS I
      [3,3,0],[3,4,0],[4,4,0],[4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],
      [10,12,0],[12,15,0],[14,17,0],[16,22,1],[19,26,1],[23,30,1]
    ],
    0x237: [  // LATIN SMALL LETTER DOTLESS J
      [4,4,1],[4,6,2],[5,6,2],[5,7,2],[6,9,3],[7,10,3],[8,13,4],[9,14,4],
      [11,17,5],[12,21,6],[15,25,8],[18,31,10],[21,37,12],[24,43,14]
    ],
    0x393: [  // GREEK CAPITAL LETTER GAMMA
      [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
      [20,19,0],[24,23,0],[28,26,0],[33,33,0],[39,38,0],[47,45,0]
    ],
    0x394: [  // GREEK CAPITAL LETTER DELTA
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
      [21,20,0],[25,24,0],[30,28,0],[35,34,0],[42,41,0],[50,47,0]
    ],
    0x398: [  // GREEK CAPITAL LETTER THETA
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,1],
      [22,21,1],[26,25,1],[31,27,0],[37,35,1],[44,42,1],[52,48,1]
    ],
    0x39B: [  // GREEK CAPITAL LETTER LAMDA
      [5,5,0],[6,7,1],[7,7,1],[8,9,1],[9,10,1],[11,12,1],[13,15,1],[15,16,1],
      [18,21,1],[22,25,1],[26,28,1],[31,35,1],[36,42,1],[43,48,1]
    ],
    0x39E: [  // GREEK CAPITAL LETTER XI
      [6,6,1],[7,7,1],[8,7,1],[9,9,1],[11,10,1],[13,12,1],[15,15,1],[18,16,1],
      [21,20,1],[25,24,1],[30,27,1],[36,33,0],[42,40,1],[50,46,1]
    ],
    0x3A0: [  // GREEK CAPITAL LETTER PI
      [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,15,0],
      [24,19,0],[29,23,0],[34,26,0],[40,33,0],[48,39,0],[57,45,0]
    ],
    0x3A3: [  // GREEK CAPITAL LETTER SIGMA
      [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],[16,14,0],[19,15,0],
      [22,19,0],[26,23,0],[31,26,0],[37,33,0],[44,39,0],[52,45,0]
    ],
    0x3A5: [  // GREEK CAPITAL LETTER UPSILON
      [6,5,0],[7,6,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],[17,14,0],[20,15,0],
      [23,20,0],[28,24,0],[33,27,0],[39,33,0],[46,40,0],[55,46,0]
    ],
    0x3A6: [  // GREEK CAPITAL LETTER PHI
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
      [21,19,0],[24,23,0],[29,26,0],[34,33,0],[41,39,0],[48,45,0]
    ],
    0x3A8: [  // GREEK CAPITAL LETTER PSI
      [6,5,0],[7,6,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],[17,14,0],[20,15,0],
      [23,19,0],[28,23,0],[33,26,0],[39,33,0],[46,39,0],[55,45,0]
    ],
    0x3A9: [  // GREEK CAPITAL LETTER OMEGA
      [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
      [21,20,0],[25,24,0],[30,27,0],[36,34,0],[42,40,0],[50,47,0]
    ]
  }
});

MathJax.Ajax.loadComplete(MathJax.OutputJax["HTML-CSS"].imgDir+"/Main/Italic"+
                          MathJax.OutputJax["HTML-CSS"].imgPacked+"/Main.js");
