<?php
/**
 * NetCommonsTreeBehaviorCase Class
 *
 * @author Noriko Arai <arai@nii.ac.jp>
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 * @copyright Copyright 2014, NetCommons Project
 */

//@codeCoverageIgnoreStart;
App::uses('NetCommonsModelTestCase', 'NetCommons.TestSuite');
//@codeCoverageIgnoreEnd;

/**
 * NetCommonsTreeBehaviorCase Class
 *
 * @package NetCommons\NetCommons\TestSuite
 * @codeCoverageIgnore
 */
abstract class NetCommonsTreeBehaviorCase extends NetCommonsModelTestCase {

/**
 * 繰り返しテスト回数(測定のため)
 *
 * @var array
 */
	const MEASUREMENT_NUMBER = 1;

/**
 * 開始時間
 *
 * @var string
 */
	protected $_startTime = null;

/**
 * 終了時間
 *
 * @var string
 */
	protected $_endTime = null;

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.net_commons.net_commons_tree_model',
		'plugin.net_commons.cake_tree_model',
	);

/**
 * Plugin name
 *
 * @var string
 */
	public $plugin = 'net_commons';

/**
 * Runs the test case and collects the results in a TestResult object.
 * If no TestResult object is passed a new one will be created.
 * This method is run for each test method in this class
 *
 * @param PHPUnit_Framework_TestResult $result The test result object
 * @return PHPUnit_Framework_TestResult
 * @throws InvalidArgumentException
 */
	public function run(PHPUnit_Framework_TestResult $result = null) {
		if (version_compare(PHP_VERSION, '7.0.0') >= 0) {
			return parent::run($result);
		}
	}

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();

		//テストプラグインのロード
		NetCommonsCakeTestCase::loadTestPlugin($this, 'NetCommons', 'TestNetCommons');
		$this->TestModel = ClassRegistry::init('TestNetCommons.TestNetCommonsTreeModel');
	}

/**
 * 不要なカラムの削除
 *
 * CakePHPとNCのTreeBehaviorでカラムが違うため
 *
 * @param mixed $data データ
 * @return mixed
 */
	protected function _removeUnnecessaryFields($data) {
		if ($this->TestModel->Behaviors->loaded('NetCommons.NetCommonsTree')) {
			$removeFields = ['lft', 'rght'];
		} else {
			$removeFields = ['sort_key', 'weight', 'child_count'];
		}

		$results = $data;
		if (is_array($data)) {
			foreach ($data as $key => $value) {
				if (is_array($value)) {
					$results[$key] = $this->_removeUnnecessaryFields($value);
				} elseif (in_array($key, $removeFields, true)) {
					unset($results[$key]);
				}
			}
		}
		return $results;
	}

/**
 * デバッグの開始
 *
 * @return void
 */
	protected function _debugStart() {
		$this->TestModel->getDataSource()->getLog();
		$this->_startTime = microtime(true);
	}

/**
 * デバッグの終了
 *
 * @param mixed $arguments 引数
 * @return void
 */
	protected function _debugEnd($arguments) {
		$this->_endTime = microtime(true);
		//debug(json_encode($arguments));
		//debug($this->_endTime - $this->_startTime);
		//debug($this->TestModel->getDataSource()->getLog()['log']);
		//debug('--EOF--');
	}

/**
 * childCount()テストのDataProvider
 *
 * @return array データ
 */
	public function dataProvider() {
		for ($number = 0; $number < self::MEASUREMENT_NUMBER; $number++) {
			$result[$number] = ['number' => $number];
		}
		return $result;
	}

}
