<?php
/**
 * PublicSpace Model
 *
 * @property Space $Space
 *
 * @author Noriko Arai <arai@nii.ac.jp>
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 * @copyright Copyright 2014, NetCommons Project
 */

App::uses('Space', 'Rooms.Model');

/**
 * PublicSpace Model
 *
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @package NetCommons\PublicSpace\Model
 */
class PublicSpace extends Space {

/**
 * Table name
 *
 * @var string
 */
	public $useTable = 'spaces';

/**
 * DefaultParticipationFixed
 *
 * @var bool
 */
	public $participationFixed = true;

/**
 * PublicSpaceルームの生成
 *
 * @param array $data デフォルト値
 * @return array PublicSpaceルーム配列
 */
	public function createRoom($data = array()) {
		$data = Hash::merge(array(
			'need_approval' => true,
			'default_participation' => true,
		), $data);

		return parent::createRoom($data);
	}

}
