<?php
/**
 * frames.name,frames.language_idを削除
 *
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 * @copyright Copyright 2014, NetCommons Project
 */

App::uses('NetCommonsMigration', 'NetCommons.Config/Migration');

/**
 * frames.name,frames.language_idを削除
 *
 * @author Shohei Nakajima <nakajimashouhei@gmail.com>
 * @package NetCommons\Frames\Config\Migration
 */
class RemoveNameOfFrames extends NetCommonsMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'remove_name_of_frames';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'drop_field' => array(
				'frames' => array('language_id', 'name', 'indexes' => array('box_id_2')),
			),
			'create_field' => array(
				'frames' => array(
					'indexes' => array(
						'box_id_2' => array('column' => array('box_id', 'is_deleted', 'weight'), 'unique' => 0),
					),
				),
			),
		),
		'down' => array(
			'create_field' => array(
				'frames' => array(
					'language_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 6, 'unsigned' => false),
					'name' => array('type' => 'string', 'null' => false, 'default' => null, 'collate' => 'utf8_general_ci', 'comment' => 'フレーム名', 'charset' => 'utf8'),
					'indexes' => array(
						'box_id_2' => array(),
					),
				),
			),
			'drop_field' => array(
				'frames' => array('indexes' => array('box_id_2')),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
