<?php
/**
 * AlterEventAddCalendarKeyAndTimezone
 *
 * @author   Ryuji AMANO <ryuji@ryus.co.jp>
 * @link http://www.netcommons.org NetCommons Project
 * @license http://www.netcommons.org/license.txt NetCommons License
 */

/**
 * Class AlterEventAddCalendarKeyAndTimezone
 */
class AlterEventAddCalendarKeyAndTimezone extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'alter_event_add_calendar_key_and_timezone';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'reservation_events' => array(
					'calendar_key' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8', 'after' => 'email_send_timing'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'reservation_events' => array('calendar_key'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
