<?php
/**
 * SlugRoute
 */

App::uses('ClassRegistry', 'Utility');

/**
 * Automatically slugs routes based on named parameters
 *
 */
class SlugRoute extends CakeRoute {

/**
 * parse
 *
 * @param string $url The URL to attempt to parse.
 * @return mixed Boolean false on failure, otherwise an array or parameters
 */
	public function parse($url) {
		$params = parent::parse($url);

		if (empty($params)) {
			return false;
		}

		$PageModel = ClassRegistry::init('Pages.Page');
		$dataSource = ConnectionManager::getDataSource($PageModel->useDbConfig);
		$tables = $dataSource->listSources();
		if (! in_array($PageModel->tablePrefix . $PageModel->useTable, $tables)) {
			return false;
		}

		$Space = ClassRegistry::init('Rooms.Space');
		if ($params['pass']) {
			$result = $Space->find('first', array(
				'conditions' => array('permalink' => $params['pass'][0]),
				'recursive' => -1
			));
			if ($result) {
				$params['spacePermalink'] = $result['Space']['permalink'];
				$params['spaceId'] = $result['Space']['id'];
				unset($params['pass'][0]);
			}
			$params['pass'] = array_values($params['pass']);
		}
		if (! isset($params['spaceId'])) {
			$result = $Space->find('first', array(
				'conditions' => array('permalink' => '', 'id !=' => Space::WHOLE_SITE_ID),
				'recursive' => -1
			));
			$params['spacePermalink'] = $result['Space']['permalink'];
			$params['spaceId'] = $result['Space']['id'];
		}

		$path = implode('/', $params['pass']);
		if ($path === '') {
			$conditions = array('Page.lft' => '1');
		} else {
			$conditions = array(
				'Page.permalink' => $path,
				'Room.space_id' => $params['spaceId']
			);
		}

		$count = $PageModel->find('count', array(
			'conditions' => $conditions,
			'recursive' => 0
		));

		if ($count) {
			$params['pagePermalink'] = $params['pass'];
			return $params;
		}

		return false;
	}

}
